<?php
namespace app\controllers;
use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\helpers\Url;
use yii\web\NotFoundHttpException;

use app\controllers\UtilController;
use app\models\Activity;
use yii\web\Session;
use yii\db\Query;
use app\components\CommonFunction;
class BillingaddressController extends Controller
{
    public $enableCsrfValidation = false;
	
	 public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'only' => ['logout'],
                'rules' => [
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

	public function actionIndex(){
		
		if(!Yii::$app->session->get('useremail')){
           $url = \Yii::$app->request->baseUrl."/login";
           return $this->redirect($url);
        }
		if(Yii::$app->params['portal_url']=='https://app.cloudkennect.com'){
			$url = \Yii::$app->request->baseUrl."/dashboard";
			return $this->redirect($url);
		}		
		
		if(Yii::$app->session->get('userid')!=Yii::$app->session->get('teamid')){
			$url = \Yii::$app->request->baseUrl."/dashboard";
			return $this->redirect($url);
		}
		
		$userDetail = Yii::$app->db->createCommand("select * from user where id =" . Yii::$app->session->get('userid'))->queryOne();
		$countries = Yii::$app->db->createCommand("select * from country")->queryAll();
		
		$Quickbook_userDetail = false;
		if(!empty($userDetail) && $userDetail['2coCustomerReference']>0){
			$postFields = array("platform_type" => '1',"user_id" => Yii::$app->session->get('userid'),"twoCoCustomerReference" => $userDetail['2coCustomerReference']);
			//echo '<br/>post fii:::<pre>'; print_r($postFields);die;

			if (YII_ENV_PROD) {
				//production
				$curl_url = "https://app.leadconnect.io/QBOConceptsTutorial-PHP/api_GetBillingInfoForInvoice.php";
			}else{
				//staging
				$curl_url = "https://nikit.intricare.net/leadconnect-backend/basic/QBOConceptsTutorial-PHP/api_GetBillingInfoForInvoice.php";
			}

			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => $curl_url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => "POST",
				CURLOPT_POSTFIELDS => $postFields,
				CURLOPT_HTTPHEADER => array(
					"Accept: application/json"
				)
			));
			//"Content-Type: application/json",
			
			$curlres = curl_exec($curl);
			//print_r($curlres);
			//die;
			$curl_res = json_decode($curlres,true);
			if($curl_res['success']==1){
				$Quickbook_userDetail = $curl_res['success_data'];
				//echo '<pre>';print_r($Quickbook_userDetail);echo '</pre>';die;
			}
		}


        return $this->render('/securepayment/billing_address_form', [
                    'message' => '',
                    'userDetail' => $userDetail,
                    'countries' => $countries,
                    'Quickbook_userDetail' => $Quickbook_userDetail,
        ]);

	}

	//NR working 22-03-2021
	public function actionAjx_update(){

		$final_result = array();
		$final_result['success'] = 0;
		
		if(!Yii::$app->session->get('useremail')){
           //$url = \Yii::$app->request->baseUrl."/login";
           //return $this->redirect($url);
			$final_result['error_msg'] = 'Your session is expired. Please, re-login and try again.';
			echo json_encode($final_result);exit;

        }
		if(Yii::$app->params['portal_url']=='https://app.cloudkennect.com'){
			//$url = \Yii::$app->request->baseUrl."/dashboard";
			//return $this->redirect($url);
			$final_result['error_msg'] = 'Invalid portal.';
			echo json_encode($final_result);exit;
		}		
		
		
		//extract($_POST);
		if(Yii::$app->session->get('userid')!=Yii::$app->session->get('teamid')){
			//$url = \Yii::$app->request->baseUrl."/dashboard";
			//return $this->redirect($url);
			$final_result['error_msg'] = 'Only admin user can change billing address.';
			echo json_encode($final_result);exit;
		}
		
		$userDetail = Yii::$app->db->createCommand("select * from user where id =" . Yii::$app->session->get('userid'))->queryOne();

		//$countries = Yii::$app->db->createCommand("select * from country")->queryAll();
		//echo '<pre>';print_r($countries);die;

		
		if(!empty($userDetail)){
			
			//echo 'dsf jkl:<pre>'; print_r($_POST);
			
			if($userDetail['2coCustomerReference']>0){

				if (YII_ENV_PROD) {
					//production
					$curl_url = "https://app.leadconnect.io/QBOConceptsTutorial-PHP/api_UpdateBillingInfoForInvoice.php";
				}else{
					//staging
					$curl_url = "https://nikit.intricare.net/leadconnect-backend/basic/QBOConceptsTutorial-PHP/api_UpdateBillingInfoForInvoice.php";
				}

				$postFields = array("platform_type" => '1',"user_id" => Yii::$app->session->get('userid'),"twoCoCustomerReference" => $userDetail['2coCustomerReference'],"custFullName" => $_POST['custFullName'], "custBillingAddress" => $_POST['custBillingAddress'], "bill_city" => $_POST['bill_city'], "bill_country" => $_POST['bill_country'], "bill_state" => $_POST['bill_state'], "bill_postal_code" => $_POST['bill_postal_code']);
				//echo '<br/>post fii:::<pre>'; print_r($postFields);die;
				$curl = curl_init();
				curl_setopt_array($curl, array(
					CURLOPT_URL => $curl_url,
					CURLOPT_RETURNTRANSFER => true,
					CURLOPT_ENCODING => "",
					CURLOPT_MAXREDIRS => 10,
					CURLOPT_TIMEOUT => 0,
					CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
					CURLOPT_CUSTOMREQUEST => "POST",
					CURLOPT_POSTFIELDS => $postFields,
					CURLOPT_HTTPHEADER => array(
						"Accept: application/json"
					)
				));
				//"Content-Type: application/json",
				
				$curlres = curl_exec($curl);
				//print_r($curlres);
				//die;
				$curl_res = json_decode($curlres,true);
				if($curl_res['success']==1){
					$final_result['success'] = 1;
					$final_result['success_msg'] = $curl_res['success_msg'];
				}else{
					$final_result['success'] = 0;
					$final_result['error_msg'] = 'Your Billing Address could not be updated.';
				}
				
			}else{
				$final_result['error_msg'] = 'It looks like you are not linked with 2checkout.';
			}
			
		}else{
			$final_result['error_msg'] = 'User not found.';
		}
		echo json_encode($final_result);exit;

	}
	

}
