<?php

namespace app\controllers;
require '../aws_php_sdk/vendor/autoload.php'; 
use Yii;
use yii\db\Query;    
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Aws\S3\S3Client;
use Aws\Exception\AwsException;

/**
 *  SchedulepostsController the CRUD actions for SequencesModel model.
 */
class AipostbuilderController extends Controller {

    /**
     * @inheritdoc
     */
    public $enableCsrfValidation = false;

    public function behaviors() {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**   
     * Lists all SequencesModel models.
     * @return mixed
     */
    public function actionIndex() {
		
        if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
        if(Yii::$app->session->get('user_role') == 1){
            $this->redirect('dashboard');
        }
		
		
		
		$onepostdata = '';
		if(isset($_REQUEST['postid']) && $_REQUEST['postid'] != ''){
		$getpost_query = new Query;
		$onepostdata = $getpost_query->select(['post_title','postContent','fileName','scheduledDateTime','visibleToConnectionsOnly','allowedCommentersScope','postId','status','mediaType','documentTitle'])
                        ->from('post')
                        ->where(['postId' => $_REQUEST['postid']])
						->one();
		} 
		 
		
		$getallpost_query = new Query;
		$allpostdata = $getallpost_query->select(['post_title','postContent','fileName','scheduledDateTime','visibleToConnectionsOnly','allowedCommentersScope','postId','status','mediaType','documentTitle','likes','comments']) 
                        ->from('post')
                        //->where(['userId' => Yii::$app->session->get('userid')])
                        ->where(" userId = '".Yii::$app->session->get('userid')."' AND status != '3' AND post_type = '1'")
						->all();
						
		//if(Yii::$app->session->get('userid') == '21196' || Yii::$app->session->get('userid') == '15040'){
		if($_SESSION['portal_id'] == 2){
			//return $this->render('post_suggest'); 
			return $this->render('index',array('onepostdata'=>$onepostdata,'allpostdata'=>$allpostdata)); 	
		}else{
			return $this->render('index',array('onepostdata'=>$onepostdata,'allpostdata'=>$allpostdata)); 	
		}
    }
	
	
	public function actionDeletepost(){
		
		 if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		
		///echo '<prE>'; print_r($_POST); exit;
		$delpostid = $_POST['delpostid'];
		
		Yii::$app->db->createCommand("Update post set status = '3' where postId = '".$delpostid."'")->execute(); 
		
	}
	
	public function actionAddnewpost(){
		
		 if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		
		///echo '<prE>'; print_r($_POST); exit;
		$user_id = Yii::$app->session->get('userid');
		
		Yii::$app->db->createCommand("INSERT INTO post (visibleToConnectionsOnly,allowedCommentersScope,userId,status,post_type) VALUES ('1','ALL','".$user_id."','4','1')")->execute(); 
		
		$postid = Yii::$app->db->getLastInsertID(); 
		
		return $postid;
		
		
	}
	
	public function actionUpdatepost(){
		
		 if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		$mergeSql='';
		///echo '<prE>'; print_r($_POST); exit;
		if(isset($_POST['postid']) && $_POST['postid'] != ''){
		//$kennectedUsrs = Yii::$app->db->createCommand("SELECT id from user where email LIKE '%kennected%' or id in (19386,14884,14926,14905,16839,19916)")->queryColumn();
		//if(in_array(Yii::$app->session->get('userid'), $kennectedUsrs)){
			if($_FILES["fileToUpload"]["size"] > 0 && $_POST['seeposttype']!=0){
				$img=$_FILES["fileToUpload"];
				$userQry = "SELECT usrprfl.linkedin_email, usrprfl.linkedin_password, usrprfl.firstName, usrprfl.lastName, usr.first_name, usr.email, usr.csrf, usr.cookie, usr.portal_id, usr.proxyIp,usr.proxyPort, usr.proxyUsername, usr.proxyPassword, usr.userAgent from user_profile usrprfl, user usr where usrprfl.user_id = usr.id AND usr.id=".Yii::$app->session->get('userid');
				$user = Yii::$app->db->createCommand($userQry)->queryOne();
				$username = $user['linkedin_email'];
				$password = $user['linkedin_password'];
				$portalId = $user['portal_id'];
				$proxyIp = $user['proxyIp'];
				$proxyPort = $user['proxyPort'];
				$proxyUsername = $user['proxyUsername'];
				$proxyPassword = $user['proxyPassword'];
				$userAgent = $user['userAgent'];
				$cookie = $user['cookie'];
				$csrf = $user['csrf'];
				$mimeType=$_FILES["fileToUpload"]["type"];
				//echo '<br>mimeType:'.$mimeType."<br>";
				$fileSize=$_FILES["fileToUpload"]["size"];
				$fileName=time().'_'.Yii::$app->session->get('userid').'_'.$_FILES["fileToUpload"]["name"];
				$media=$_FILES["fileToUpload"]["tmp_name"];
				
				$target_dir = Yii::getAlias('@webroot')."/postmedia/";
				$target_file = $target_dir . basename($fileName);
				if (move_uploaded_file($media, $target_file)) {	
				  chmod($target_file,0777);
				}
				
				$credentials = new \Aws\Credentials\Credentials('AKIA2BIJALKAVZ7OR3IK', 'LHnhwkBth6yHymhRTk8aNdBtj2+Ra4Rslj1UPDhH');
				$bucket="linkedfusionpostmedia";
				//$file_path='/var/www/leadconnect_cloud/basic/web/img/integration_logo.jpg';		
				$s3Client = new S3Client([
					//'profile' => 'default',
					'region' => 'us-east-1',  
					'version' => 'latest',
					'credentials' => $credentials
				]);
				//Upload media in s3
				$result = $s3Client->putObject([
					'Bucket' => $bucket,
					'Key' => basename($target_file),    
					'SourceFile'   => $target_file,
					'ACL'          => 'public-read',
					'ServerSideEncryption' => 'AES256',
				]);  
				
				if(isset($_POST['postid'])){
					$userQry = "SELECT p.fileName FROM `post` p WHERE p.fileName is not null AND p.fileName !='' AND p.imageDeletedS3=0 AND p.postId=".$_POST['postid'];
					$existFileName = Yii::$app->db->createCommand($userQry)->queryScalar();
					if(!empty($existFileName)){
						try{
							$deleteExistFileName = $s3Client->deleteObject([
								'Bucket' => $bucket,
								'Key'    => $existFileName 
							]);
						}catch(AwsException $e){
							
						}
					} 
				}
				if($_POST['seeposttype']==1){
					$mediaUploadType='IMAGE_SHARING';
					$documentTitle='';
				}elseif($_POST['seeposttype']==2){
					$mediaUploadType='VIDEO_SHARING';
					$documentTitle='';
				}else{
					$mediaUploadType='DOCUMENT_SHARING';
					$documentTitle= $this->mb_htmlentities($this->convert_emoji(nl2br(str_replace("'","\'",$_POST['documentname']))));;
				}
				$postBodyUpload="{\"mediaUploadType\": \"".$mediaUploadType."\", \"fileSize\": ".$fileSize.", \"filename\": \"".$fileName."\"}";
				$curl = curl_init();
				curl_setopt_array($curl, array(
					CURLOPT_URL => 'https://www.linkedin.com/voyager/api/voyagerMediaUploadMetadata?action=upload',
					CURLOPT_RETURNTRANSFER => true,
					CURLOPT_ENCODING => "",
					CURLOPT_MAXREDIRS => 10,
					CURLOPT_TIMEOUT => 30,
					CURLOPT_HEADER=>true,
					CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
					CURLOPT_HTTPPROXYTUNNEL => 1,
					CURLOPT_PROXY => "$proxyIp",
					CURLOPT_PROXYPORT => "$proxyPort",
					CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
					CURLOPT_CUSTOMREQUEST => "POST",
					CURLOPT_POSTFIELDS => $postBodyUpload,
					CURLOPT_HTTPHEADER => array(
						"cookie: $cookie",
						"csrf-token: $csrf",
						"Host: www.linkedin.com",
						"User-Agent: $userAgent",
						"accept: application/vnd.linkedin.normalized+json+2.1",
						"Accept-Language: en-US,en;q=0.9", 
						"Accept-Encoding: gzip, deflate, br", 
						"content-length:".strlen($postBodyUpload),
						"content-type: application/json; charset=UTF-8",
						"referer: https://www.linkedin.com/feed/?trk=hb_signin",
						"origin: https://www.linkedin.com"
					) 
				)); 
				$res = curl_exec($curl); 
				$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
				$headers = substr($res, 0, $header_size);
				$res = substr($res, $header_size);
				$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
				if($http_code == 200 || $http_code == 201 ){
					//echo "1</br>";
					$response=json_decode($res); 
					//print_r($response);
					if(isset($response->data->value->type) && $response->data->value->type=='SINGLE'){
						$uploadUrl=(isset($response->data->value->singleUploadUrl))?$response->data->value->singleUploadUrl:'';
						//echo '<br>uploadUrl:'.$uploadUrl."<br>";
						$mediaT=(isset($response->data->value->singleUploadHeaders))?(array)$response->data->value->singleUploadHeaders:'';
						$mediaTypes=$mediaT['media-type-family'];
						//echo '<br>mediatype:'.$mediaTypes."<br>";
						$urn=(isset($response->data->value->urn))?$response->data->value->urn:'';
						//echo '<br>urn:'.$urn."<br>";
						$file_path="/var/www/leadconnect_cloud/basic/web/postmedia/".$fileName;
						$image = fopen($file_path, "rb");
						$curl = curl_init();
						curl_setopt_array($curl, array(
							CURLOPT_URL => $uploadUrl,
							CURLOPT_RETURNTRANSFER => true,
							CURLOPT_BINARYTRANSFER => true,
							CURLOPT_ENCODING => "",
							CURLOPT_MAXREDIRS => 10,
							CURLOPT_TIMEOUT => 30,
							CURLOPT_HEADER=>true,
							CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
							CURLOPT_HTTPPROXYTUNNEL => 1,
							CURLOPT_PROXY => "$proxyIp",
							CURLOPT_PROXYPORT => "$proxyPort",
							CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
							CURLOPT_PUT => true,
							CURLOPT_INFILE => $image,
							CURLOPT_INFILESIZE => $fileSize,
							CURLOPT_CONNECTTIMEOUT =>2,
							CURLOPT_HTTPHEADER => array(
								"cookie: $cookie",
								"csrf-token: $csrf",
								"User-Agent: $userAgent",
								"accept: */*",
								"Accept-Language: en-US,en;q=0.9", 
								"media-type-family: ".$mediaTypes,
								"Accept-Encoding: gzip, deflate, br",
								"content-type: ".$mimeType, 
								"referer: https://www.linkedin.com/feed/?trk=hb_signin",
								"origin: https://www.linkedin.com"
							) 
						));  
						$res = curl_exec($curl); 
						$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
						$headers = substr($res, 0, $header_size);
						$res = substr($res, $header_size);
						$mergeSql="mediaType=".$_POST['seeposttype'].",fileName='".$fileName."',mediaUrn='".$urn."',documentTitle='".$documentTitle."',";
						$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
						if($http_code == 200 || $http_code == 201 ){ 
							$mergeSql="mediaType=".$_POST['seeposttype'].",fileName='".$fileName."',mediaUrn='".$urn."',documentTitle='".$documentTitle."',";
							/* echo "2</br>";
							$visibleToConnectionsOnly="false";
							$postContent="Hi connections";
							$allowedCommentersScope="ALL";   
							echo $postBody="{\"visibleToConnectionsOnly\":".$visibleToConnectionsOnly.",\"commentsDisabled\":false,\"externalAudienceProviders\":[],\"commentaryV2\":{\"text\":\"".$postContent."\",\"attributes\":[]},\"origin\":\"FEED\",\"allowedCommentersScope\":\"".$allowedCommentersScope."\",\"media\":[{\"category\":\"".$mediaTypes."\",\"mediaUrn\":\"".$urn."\",\"tapTargets\":[],\"recipes\":[\"urn:li:digitalmediaRecipe:feedshare-video-captions-thumbnails-ambry\"]}]}";  */  
							 
						}
					}else if(isset($response->data->value->type) && $response->data->value->type=='MULTIPART'){ 
						// $partUploadRequests=(isset($response->data->value->partUploadRequests))?(array)$response->data->value->partUploadRequests:'';
						// if(!empty($partUploadRequests)){
						// 	$urn=(isset($response->data->value->urn))?$response->data->value->urn:'';
						// 	for($i=0;$i<=count($partUploadRequests);$i++){
						// 		$partUploadRequests=(array)$partUploadRequests[$i];
						// 		$uploadUrl=(isset($partUploadRequests['uploadUrl']))?$partUploadRequests['uploadUrl']:'';
						// 		$lastByte=(isset($partUploadRequests['lastByte']))?$partUploadRequests['lastByte']:'';
						// 		$partUploadRequestsHeaders=(array)$partUploadRequests['headers'];
						// 		$contentTypes=(isset($partUploadRequestsHeaders['Content-Type']))?$partUploadRequestsHeaders['Content-Type']:''; 
						// 		$mediaTypes='VIDEO';
								
						// 		$path=explode('https://www.linkedin.com',$uploadUrl);
						// 		$file_path="/var/www/leadconnect_cloud/basic/web/postmedia/".$fileName;
						// 		$image = fopen($file_path, "rb");
						// 		$curl = curl_init();
						// 		curl_setopt_array($curl, array(
						// 			CURLOPT_URL => $uploadUrl,
						// 			CURLOPT_RETURNTRANSFER => true,
						// 			CURLOPT_BINARYTRANSFER => true,
						// 			CURLOPT_ENCODING => "",
						// 			CURLOPT_MAXREDIRS => 10,
						// 			CURLOPT_TIMEOUT => 30,
						// 			CURLOPT_HEADER=>true,
						// 			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
						// 			CURLOPT_HTTPPROXYTUNNEL => 1,
						// 			CURLOPT_PROXY => "$proxyIp",
						// 			CURLOPT_PROXYPORT => "$proxyPort",
						// 			CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
						// 			CURLOPT_PUT => true,
						// 			CURLOPT_INFILE => $image,
						// 			CURLOPT_INFILESIZE => $fileSize,
						// 			CURLOPT_CONNECTTIMEOUT =>2,
						// 			CURLOPT_HTTPHEADER => array(
						// 				"cookie: $cookie",
						// 				"csrf-token: $csrf",
						// 				"User-Agent: $userAgent",
						// 				"accept: */*",
						// 				"Accept-Language: en-US,en;q=0.9", 
						// 				//"media-type-family: VIDEO",
						// 				"Accept-Encoding: gzip, deflate, br",
						// 				"content-type: ".$contentTypes,
						// 				"content-length:".$lastByte,
						// 				//"Path:".$path[1], 
						// 				"referer: https://www.linkedin.com/feed/",
						// 				"origin: https://www.linkedin.com",
						// 				"authority: www.linkedin.com"
						// 			) 
						// 		));  
						// 		$res = curl_exec($curl);
						// 		$header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
						// 		$headers = substr($res, 0, $header_size);
						// 		//print_r($headers);exit;
						// 		$res = substr($res, $header_size);
						// 		$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
						// 		if($http_code == 200 || $http_code == 201 ){ 
									
						// 		}
						// 	}
						// 	$mergeSql="mediaType=2,fileName='".$fileName."',mediaUrn='".$urn."',";	 
						// }
						
					}
				}
				unlink($target_file);
			}
		//}
			
		//echo htmlentities($_POST['postcontent']); die;
		
		$postid = $_POST['postid'];
		$user_id = Yii::$app->session->get('userid');
		$seepost = $_POST['seepost'];		
		$commentonpost = $_POST['commentonpost'];		
		
		$start_date = str_replace(",", "", $_POST['pickadate']);
        $start_time = date("H:i", strtotime($_POST['pickatime'])). ":00";

		
		$scheduledDateTime = date_create($start_date);
        $start_date = date_format($scheduledDateTime, "Y-m-d");
        $scheduledDateTime = $start_date . " " . $start_time;
	
		
		$postcontent = $this->mb_htmlentities($this->convert_emoji(nl2br(str_replace("'","\'",$_POST['postcontent']))));	
		$posttitle = $this->mb_htmlentities($this->convert_emoji(nl2br(str_replace("'","\'",$_POST['posttitle']))));	
		
		//echo "INSERT INTO post (postContent,scheduledDateTime,visibleToConnectionsOnly,allowedCommentersScope,userId) VALUES ('".$postcontent."','".$scheduledDateTime."','".$seepost."','".$commentonpost."','".$user_id."')"; exit;
		
		Yii::$app->db->createCommand("UPDATE post set ".$mergeSql." post_title = '".$posttitle."', postContent = '".$postcontent."',	scheduledDateTime = '".$scheduledDateTime."',		visibleToConnectionsOnly ='".$seepost."', allowedCommentersScope ='".$commentonpost."', status = '0' where userId = '".$user_id."' and postId ='".$postid."'")->execute(); 
		
		$this->redirect('index');
		
		}
		
		
	}
	
	
	public function actionPostspagination() // post list
	{
		  if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		 
		 $perpageoffset = $_POST['perpageoffset'];
		  
		 $currentPage = $_POST['pagenum'];
		 
		 $perpage = 5;
		 
		 $totsqlpostlist = "SELECT  post_title,postContent,scheduledDateTime,visibleToConnectionsOnly,allowedCommentersScope,postId,status from post where  status != '3' AND post_type = '1' AND  userId = ".Yii::$app->session->get('userid');
		 $countpostlist = Yii::$app->db->createCommand($totsqlpostlist)->queryAll();
		 
		 if(isset($_POST['totalRowsCount']))
		 {
			 $totalPage = $_POST['totalRowsCount'] / $perpage;
		 }else{
			  $totalPage = count($countpostlist) / $perpage;
		 }
		
		 $totalPagecount = ceil($totalPage);
		 

        $sqlpostlist = "SELECT  post_title,postContent,scheduledDateTime,visibleToConnectionsOnly,allowedCommentersScope,postId,status,likes,comments from post where status != '3' AND post_type = '1' AND userId = " . Yii::$app->session->get('userid') . " order by postId DESC limit $perpageoffset,$perpage ";
        $postlist = Yii::$app->db->createCommand($sqlpostlist)->queryAll();
		
		?>
		<table class="table table-striped table mb-0 sequencesMainList" id="sequencesMainList">
										<thead>
											<tr>                          
												<th class="text-center" style="padding: 0 10px;">#</th>
												<th class="text-center">Title</th>
												<th>Schedule On</th>
												<th style="text-align:center;" >Visible</th>
												<th style="text-align:center;" >Likes</th>
												<th style="text-align:center;" >Comments</th>
												<th class="text-center" data-hide="phone,tablet" width="20%">Commenters</th>
												<th class="text-center" data-hide="phone,tablet">Options</th>
											</tr>
										</thead>
										<tbody>
												<?php $i=1; 
												$sn = ($currentPage * $perpage - ($perpage)) + 1;
												foreach($postlist as $rows){ 
												 
												$statusbadge = 'info';
													if($rows['status'] == '1')
													{
														$statusbadge = 'success'; 
														 
													}else if($rows['status'] == '2')
													{
														$statusbadge = 'danger'; 
													}	
													else if($rows['status'] == '4')
													{
														$statusbadge = 'primary'; 
													}													
													else{
														$statusbadge = 'info';
													} 
													
													$scheduledDate = '';
													$scheduledTime = '';
													
													$scheduledDateTime = explode(' ',$rows['scheduledDateTime']);
													$scheduledDate = $scheduledDateTime[0];
													$scheduledDate = date_create($scheduledDate);
													$scheduledDate = date_format($scheduledDate, "d M, Y");
													$scheduledTime = date('h:i A', strtotime($rows['scheduledDateTime']));
													
													if($rows['visibleToConnectionsOnly'] == 1){
													$visbleto = 'Connections';
													}else{
													$visbleto = 'All';	
													}
												    
													if($rows['allowedCommentersScope'] == 'ALL'){
													$commentor = 'All';
													} 
													elseif($rows['allowedCommentersScope'] == 'CONNECTIONS_ONLY')
													{
														$commentor = 'Connections Only';
													}
													else{
														$commentor = 'None';
													}
													
													$flag ='';
													if($rows['status'] == 1) 
													{ 
														$flag = 'Sent'; 
													}
													else if($rows['status'] == 2)
													{ 
														$flag = 'Error';
													} 
													else if($rows['status'] == 4)
													{ 
														$flag = 'Not Started';
													} 
													else 
													{ 
														$flag = 'Pending'; 
													} 
                                                    
												
													
												?>
												<tr class="row_class">
													<td class="text-center"><?php echo $sn; ?></td> 
													<td class="text-center"><a style="font-size: 12px;margin-top: 4px; color:#727E8C;" title="<?php echo $rows['post_title']; ?>" href="?postid=<?php echo $rows['postId']; ?>"><?php if(strlen($rows['post_title']) > 15 ){ echo substr($rows['post_title'],0,15); } else { echo $rows['post_title']; } ?></a><br><div style="padding: 2px;margin-left: 8px;font-size: 10px; border-radius: 2px;" class="badge badge-pill badge-light-<?php echo $statusbadge; ?> mr-1 mb-1 " id="ch_stat_<?php echo  $rows['postId']; ?>"><?php echo $flag; ?></div></td> 
													<td><span><?php echo $scheduledDate.' '.$scheduledTime; ?></span>
													</td>
													<td class="text-center"><?php echo $visbleto; ?></td>
													<td class="text-center"><?php echo $rows['likes']; ?></td>
													<td class="text-center"><?php echo $rows['comments']; ?></td>
													<td class="text-center"><?php echo $commentor; ?></td>											
													<td  class="text-center py-1">
                                                    <div class="dropdown">
                                                        <span class="bx bx-dots-vertical-rounded font-medium-3 dropdown-toggle nav-hide-arrow cursor-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" role="menu"></span>
                                                        <div class="dropdown-menu dropdown-menu-right">
                                                        
															<?php if($rows['status'] != 1 && $rows['status'] != 2 ) { ?>
															<a class="dropdown-item" href="?postid=<?php echo $rows['postId']; ?>"  title="Edit Post" ><i class="bx bx-edit-alt mr-1"></i>edit</a>
												<?php } else{ if($rows['status'] == 1) {echo '<a class="dropdown-item" href="javascript:void(0);"  title="Sent" >Sent</a>';}
													if($rows['status'] == 2) {}
												}?>

														<a href="javascript:void(0);" class="delete_post dropdown-item" data-post-id="<?php echo $rows['postId']; ?>" title="Delete Post" ><i class="bx bx-trash mr-1"></i>delete</a> 
															
                                                        </div>
                                                    </div>
                                                </td>	
												</tr>
												<?php $i++;$sn++; } ?>  
										</tbody>
									</table>
									<!-- Pagination  -->
									<input type="hidden" name="totalRowsCount" value="<?php echo count($countpostlist);?>" id="totalRowsCount" />
									<div class="dataTables_info" id="DataTables_Table_4_info" role="status" aria-live="polite">Showing <?php echo $perpageoffset; ?> to <?php if($currentPage < $totalPagecount){echo $perpage * $currentPage; } else{ echo count($countpostlist); } ?> of <?php echo count($countpostlist);?> entries</div>
									<div class="pagination paginationcon">
									<?php if($totalPagecount > 1){ ?>
									<ul class="pagination">
										<!-- Previous -->
										<li class="Prevpagedata" >
										<a class="page-link" href="javascript:void(0);" >Previous</a>
										</li>
										<!-- Previous End -->
										<?php 
										$perpagdata = 0;
										for($p=1; $p <= $totalPagecount; $p++){ 
										if($p > 1){
											$perpagdata = $perpage * $p - $perpage;
										}
										?>
										<li onClick="changePage(<?php echo $perpagdata; ?>,<?php echo $p; ?>);"  class="showthispage_<?php echo $perpagdata; ?> <?php if($p==$currentPage){?>active<?php } ?>">
										<a href="javascript:void(0);" class="page-link"><?php echo $p; ?></a>
										</li>
										<?php } ?>
										<!-- Next -->
										<li class="Nextpagedata" >
										<a class="page-link" href="javascript:void(0);" >Next</a>
										</li>
										<!-- Next End -->
										
									</ul>
									<?php } ?>
									</div>
									<!--End Pagination  -->
									
		<?php 
	}
	
	
	public function actionGettweetsfeeds(){
		
		if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		
		$keywordtext = '';
		if(isset($_POST['keywordtext'])){
		$keywordtext = $_POST['keywordtext'];
		}
		$ftlikesCount = 0;
		if(isset($_POST['likesCount']) && $_POST['likesCount'] != ''){
		$ftlikesCount = $_POST['likesCount'];
		}
		
		$ftretweetsCount = 0;
		if(isset($_POST['retweetsCount']) && $_POST['retweetsCount'] != ''){
		$ftretweetsCount = $_POST['retweetsCount'];
		}
		
		$arrayspe = array('&','and','AND','And','or','OR','-','/',',');
		//$keywordtext = str_replace("","&",$keywordtext);
		foreach($arrayspe as $val){
		$keywordtext = str_replace($val,"",$keywordtext); 
		}
		//echo $keywordtext; exit;
		$keywordtext = urlencode($keywordtext);
		$keywordtext = str_replace("+","%20",$keywordtext);
		
		$nextpageqry = '';
		if(!empty($_POST['nextpagetoken']) && isset($_POST['nextpagetoken'])){
			$nextpageqry = '&next_token='.$_POST['nextpagetoken'];
		}
		
		$linkedin_ProfilePic = Yii::$app->db->createCommand("select ProfilePic400_400,firstName,lastName from user_profile where user_id='" .Yii::$app->session->get('userid'). "'")->queryOne();

			if(!empty($linkedin_ProfilePic)) {
			$linkedin_Profile_img = $linkedin_ProfilePic['ProfilePic400_400'];
			$linkedfullname = $linkedin_ProfilePic['firstName'].' '.$linkedin_ProfilePic['lastName'];
			} else {
			$linkedin_Profile_img = Yii::$app->request->baseUrl . '/img/no-user.png';
			$linkedfullname = 'LinkedIn';
			}
		
		
		// Likes,created https://api.twitter.com/2/tweets/search/recent?query=cricket&tweet.fields=created_at,public_metrics,text 
		// https://api.twitter.com/2/tweets/search/recent?query=%22'.$keywordtext.'%22&max_results=10'.$nextpageqry
		
		// https://api.twitter.com/2/tweets/search/recent?query='.$keywordtext.'&expansions=author_id,in_reply_to_user_id,referenced_tweets.id.author_id&user.fields=entities,name,profile_image_url,username&max_results=100'.$nextpageqry
		
		// https://api.twitter.com/2/tweets/search/recent?query='.$keywordtext.'&tweet.fields=created_at,public_metrics,text&max_results=100'.$nextpageqry
		
		$curl = curl_init();

			curl_setopt_array($curl, array(
			  CURLOPT_URL => 'https://api.twitter.com/2/tweets/search/recent?query='.$keywordtext.'&expansions=author_id,in_reply_to_user_id,referenced_tweets.id.author_id&user.fields=name,profile_image_url,username&tweet.fields=created_at,public_metrics,text&max_results=100'.$nextpageqry, 
			  CURLOPT_RETURNTRANSFER => true,
			  CURLOPT_ENCODING => '',
			  CURLOPT_MAXREDIRS => 10,
			  CURLOPT_TIMEOUT => 0,
			  CURLOPT_FOLLOWLOCATION => true,
			  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			  CURLOPT_CUSTOMREQUEST => 'GET',
			  CURLOPT_HTTPHEADER => array(
				'Content-Type: application/json',
				'Authorization: Bearer AAAAAAAAAAAAAAAAAAAAANkmhQEAAAAAwO%2FGdrE8Z0xEln0xKpfVwo1WLoI%3DRLrU7PsoAPisenaEmEiBqZE0PklJIUzx8i59gpWOJEqVLjgAmU',
				'Cookie: guest_id=v1%3A166298658975254295'
			  ),
			));

			$response = curl_exec($curl);
			curl_close($curl);
			$thtml = '';
			
			//echo $response; exit;
			
			if(!empty($response)){ 
				$tweetsarray = json_decode($response,true);
				
				//echo '<pre>'; print_r($tweetsarray); exit;
				
				$tweetuserarray = array();				
				if(!empty($tweetsarray['includes']['users'])){					
					foreach($tweetsarray['includes']['users'] as $usert){						
					$tweetuserarray[$usert['id']] = array('id'=>$usert['id'],'name'=>$usert['name'],'username'=>$usert['username'],'profile_image_url'=>$usert['profile_image_url']);
					}					
				}
				
				//echo '<pre>'; print_r($tweetuserarray); exit;
				
				/* $e = $elementData['*elements'];
				$includeddata= $conversationJsonResponse->included;
				
				$merged = array();
				$entityUrn_Arr = array_column($includeddata, 'entityUrn');
				for($i2=0; $i2<count($e); $i2++) { 
					$eukey = array_search($e[$i2],$entityUrn_Arr); 
					if($eukey){				
						$temp = (object) array_merge((array)$e[$i2], (array)$includeddata[$eukey]);
						array_push($merged, $temp);
					} 
				}
				$merged2 = array();  
				for($i3=0; $i3<count($merged); $i3++) {

					$elementDt=(array)$merged[$i3];
					$ex = $elementDt['*events'][0];
					$eukey = array_search($ex,$entityUrn_Arr);
					if((string)$eukey!=''){				 
						$temp = (object) array_merge($elementDt, (array)$includeddata[$eukey]);
						array_push($merged2, $temp);
					} 
				}  */
		
				$nextpagtoken = '_next_pg_token_tweet##@@';
				if(isset($tweetsarray['meta']) && !empty($tweetsarray['meta']))
				{
					if(!empty($tweetsarray['meta']['next_token']) && isset($tweetsarray['meta']['next_token'])){
						$nextpagtoken = $tweetsarray['meta']['next_token'].'_next_pg_token_tweet##@@';
					}
				}
				
				//echo '<prE>'; print_r($tweetsarray['data']); exit;
				
				if(isset($tweetsarray['data']) && !empty($tweetsarray['data'])){
					$thtml .= $nextpagtoken; 
					$tweetsArray = array();
					$ord=array();
					for($i=0; $i < count($tweetsarray['data']);  $i++){
						$rtweet = $tweetsarray['data'][$i];
						$likesCount = 0;
						if(isset($rtweet['public_metrics']['like_count'])){
							$likesCount = $rtweet['public_metrics']['like_count'];
						}
						$retweetCount = 0;
						if(isset($rtweet['public_metrics']['retweet_count'])){
							$retweetCount = $rtweet['public_metrics']['retweet_count'];
						}
						$totalrlcount = $likesCount + $retweetCount; 
						$tweetsarray['data'][$i]['totalCount'] = $totalrlcount; 
						$ord[] = $totalrlcount;					
					}
					usort($tweetsarray['data'], function($a,$b){if ($a == $b){return 0;}return ($a['totalCount'] > $b['totalCount']) ? -1 : 1;});
					///echo '<pre>'; print_r($tweetsarray['data']); exit;
					foreach($tweetsarray['data'] as $rtweet)
					{
						if(strlen($rtweet['text']) > 200){
							$tweettext = substr($rtweet['text'],0,200).'...';
						}
						else{
						   $tweettext = $rtweet['text'];
						}
						//echo $rtweet['author_id']; exit;
						//print_r(arsearch($tweetuserarray, 'id', $rtweet['author_id'])); exit;
						
						$createdDate = $rtweet['created_at'];
						$createdDate = str_replace('/', '-', $createdDate);
						//$createdDate = 'Tweet @ '.date('h:i A ~ M d, Y', strtotime($createdDate));						
						$createdDate = date('M d, Y', strtotime($createdDate));						
						$likesCount = 0;
						if(isset($rtweet['public_metrics']['like_count'])){
						$likesCount = $rtweet['public_metrics']['like_count'];
						}
						
						$retweetCount = 0;
						if(isset($rtweet['public_metrics']['retweet_count'])){
						$retweetCount = $rtweet['public_metrics']['retweet_count'];
						}
						$tweetUser = $tweetuserarray[$rtweet['author_id']];
						$tweetUserFullName = (isset($tweetUser['name']) && !empty(isset($tweetUser['name'])))?$tweetUser['name']:$linkedfullname;
						$tweetUserPicture = (isset($tweetUser['profile_image_url']) && !empty(isset($tweetUser['profile_image_url'])))?$tweetUser['profile_image_url']:$linkedin_Profile_img;
						$tweetUsername = (isset($tweetUser['username']) && !empty(isset($tweetUser['username'])))?$tweetUser['username']:"";
						
						$thtml .=  '<li id="post_id_'.$rtweet['id'].'">';
						$thtml .=   '<div class="top_item">';
						$thtml .=   '<span class="item_img"><img src="'.$tweetUserPicture.'" style="height:20px; width:20px; border-radius:50px;" /></span>';
						$thtml .=   '<span class="item_name" title="'.$tweetUserFullName.'" style="text-transform: capitalize; ">'.$tweetUserFullName.'</span>';
						$thtml .=   '<span class="item_like"><a class="primary" title="Likes" style="padding:3px;"><i style="font-size: 0.9rem;" class="bx bx-like"></i> <span style="color:#8993A4;">'.$likesCount.'</span></a></span>';
						$thtml .=   '<span class="item_retweet"><a class="warning " title="Retweets" style="padding:3px;"><img src="https://app.linkedfusion.io/api/openai/retweet-24.png" style="transform: rotate(90deg);height: 14px;" /> <span style="color:#8993A4;">'.$retweetCount.'</span></a></span>'; 
						$thtml .=   '</div>';
						$thtml .=   '<div class="item_date"><b>'.$createdDate.'</b></div>';
						$thtml .=   '<div class="item_content">'.$tweettext.'</div>';
						$thtml .=   '<div style="margin-top: 5px;"><a href="https://twitter.com/'.$tweetUsername.'/status/'.$rtweet['id'].'" target="_blank"  class="item_read">Read More</a></div>';
						$thtml .=   '<div class="text-right"><a href="javascript:void(0);" data-postid="'.$rtweet['id'].'" class="edit_post_content">Use this</a></div>'; 
						$thtml .= '</li>';
						$tweetsArray[$rtweet['id']] = array('id'=>$rtweet['id'],'created'=>$createdDate,'text'=>$tweettext,'retweet'=>$retweetCount,'likes'=>$likesCount);
						
					} 
				} 
			
			}
			else{
				$thtml .= '<li>No post found!</li>';
			}
			
			//$tweetsArray['totalCount'] = count($tweetsArray); 
			
			//echo '<prE>'; print_r($tweetsArray); exit; 
			
			//return json_encode($tweetsArray);
			echo $thtml;
		 
		
	}
	
	function cmp($a, $b){
        if ($a == $b)
            return 0;
        return ($a['totalCount'] < $b['totalCount']) ? -1 : 1;
    }
	
	
    function arsearch($array, $key, $value)
	{
		$results = array();

		if (is_array($array)) {
			if (isset($array[$key]) && $array[$key] == $value) {
				$results[] = $array;
			}

			foreach ($array as $subarray) {
				$results = array_merge($results, arsearch($subarray, $key, $value));
			}
		}

		return $results;
	}
	
	public function actionGetpostcontentbyid(){
		if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
			
			$postid = '';
			
			if(isset($_POST['post_id']) && !empty($_POST['post_id'])){
			
				$postid = trim($_POST['post_id']);
				
				$curl = curl_init();
				curl_setopt_array($curl, array(
				  CURLOPT_URL => 'https://api.twitter.com/2/tweets?ids='.$postid.'&expansions=referenced_tweets.id,referenced_tweets.id.author_id,entities.mentions.username,in_reply_to_user_id,attachments.media_keys', 
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => '',
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 0,
				  CURLOPT_FOLLOWLOCATION => true,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => 'GET',
				  CURLOPT_HTTPHEADER => array(
					'Content-Type: application/json',
					'Authorization: Bearer AAAAAAAAAAAAAAAAAAAAANkmhQEAAAAAwO%2FGdrE8Z0xEln0xKpfVwo1WLoI%3DRLrU7PsoAPisenaEmEiBqZE0PklJIUzx8i59gpWOJEqVLjgAmU',
					'Cookie: guest_id=v1%3A166298658975254295'
				  ),
				));

				$response = curl_exec($curl);
				curl_close($curl);
				
				if(!empty($response))
				{
					$response = json_decode($response,true);
					$fullcontent ='';
					if(isset($response['includes']['tweets'][0]['text']) && !empty($response['includes']['tweets'][0]['text'])){
					$fullcontent = $response['includes']['tweets'][0]['text'];
					}else{
							
						if(isset($response['data'][0]['text']) && !empty($response['data'][0]['text'])){
							
							$fullcontent = $response['data'][0]['text'];
						}
							
					}
					
					$regex = "@(https?://([-\w\.]+[-\w])+(:\d+)?(/([\w/_\.#-]*(\?\S+)?[^\.\s])?)?)@";
					$fullcontent = preg_replace($regex, ' ', $fullcontent);
					
					echo $fullcontent;
				}
			
			}
		
	}
	
	public function actionPostresponsecontent()
	{
		if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		
		
		
		$prompttext = '';
		$response_type ='';
		$post_content_edit ='';
		if(isset($_POST['response_type']) && !empty($_POST['response_type']) && isset($_POST['post_content_edit']) && !empty($_POST['post_content_edit'])){
		
		
		
		
		$response_type = $_POST['response_type'];
		$post_content_edit = preg_replace('/\s+/', ' ', $_POST['post_content_edit']);
		
		if($_POST['response_type'] == 'rewrite'){
		$prompttext = 'write an positive  essay on:\n\n'.$post_content_edit; 
		}else{
		$prompttext = 'Write something '.$response_type.':\n\n'.$post_content_edit;	
		}
		//echo $prompttext; exit;
		
				  $curl = curl_init();
				  curl_setopt_array($curl, array(
				  CURLOPT_URL => 'https://api.openai.com/v1/completions',
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => '',
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 0,
				  CURLOPT_FOLLOWLOCATION => true,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => 'POST',
				  CURLOPT_POSTFIELDS =>'{
				  "model": "text-davinci-002",
				  "prompt": "'.$prompttext.'",
				  "temperature": 0.7,
				  "max_tokens": 2000,
				  "top_p": 1,
				  "frequency_penalty": 0,
				  "presence_penalty": 0
				}',
				  CURLOPT_HTTPHEADER => array(
					'Content-Type: application/json',
					'Authorization: Bearer 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'
				  ),
				));

				$response = curl_exec($curl);

				curl_close($curl);
				
				//echo $response; exit;
				
				if(!empty($response)){
					
					$response = json_decode($response,true);
 					
					if(isset($response['choices'][0]['text']))
					{
						echo $response['choices'][0]['text'];
					}else{
						echo 'No content found!';
					}
				}else{
					echo 'No content found!';
				}
		}
	}
	
	
	public function actionSerachcategory()
	{
		if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		
		if(isset($_POST['src_keyword']) && !empty($_POST['src_keyword'])){
			$keywordsrc = $_POST['src_keyword'];
			$searchcategory = "SELECT id,name FROM `post_categories` WHERE `name` LIKE '%".$keywordsrc."%' LIMIT 5";
			$srcdata = Yii::$app->db->createCommand($searchcategory)->queryAll();
			
			$categoryhtml = '';
			if(!empty($srcdata))
			{
				foreach($srcdata as $crow){
					
					$categoryhtml .=  '<span class="category_name" data-id="'.$crow['id'].'">'.$crow['name'].'</span>';
					
				}
			}
			
		}else{
			
			$searchcategory = "SELECT id,name FROM `post_categories` LIMIT 5";
			$srcdata = Yii::$app->db->createCommand($searchcategory)->queryAll();
						
			$categoryhtml = '';
			if(!empty($srcdata))
			{
			foreach($srcdata as $crow){
			$categoryhtml .=  '<span class="category_name" data-id="'.$crow['id'].'">'.$crow['name'].'</span>';
			}
			}
		}
		
		echo $categoryhtml;
		
	}
	
	public function actionSaveusercategory(){
		
		if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		
		$categorytext = $_POST['categorytext'];
		$categoryid = $_POST['categoryid'];
		
		$checkUser = Yii::$app->db->createCommand("SELECT user_id FROM post_category_user WHERE user_id ='".Yii::$app->session->get('userid')."'")->queryOne();
		
		if(!empty($checkUser) && $checkUser['user_id'] == Yii::$app->session->get('userid'))
		{
			if(isset($_POST['categorytext']) && isset($_POST['categoryid']) && !empty($_POST['categoryid'])){
				
				$updatesavesql = Yii::$app->db->createCommand("Update post_category_user  set category_id = '".$_POST['categoryid']."', category_name = '".$_POST['categorytext']."' where user_id = '".Yii::$app->session->get('userid')."'")->execute();
				
			}
		}
		else{
			if(isset($_POST['categorytext']) && isset($_POST['categoryid']) && !empty($_POST['categoryid'])){
				$savesql = Yii::$app->db->createCommand("INSERT INTO post_category_user (user_id,category_id,category_name) VALUES ('".Yii::$app->session->get('userid')."','".$_POST['categoryid']."','".$_POST['categorytext']."')")->execute();
			}
		}
	}
	
	public function actionPostcontentrewrite()
	{
		if (!Yii::$app->session->get('useremail')) {
            $url = \Yii::$app->request->baseUrl . "/login";
            return $this->redirect($url);
        }
		
		$content_rewrite ='';
		if(isset($_POST['content_rewrite']) && !empty($_POST['content_rewrite'])){
		$content_rewrite = preg_replace('/\s+/', ' ', $_POST['content_rewrite']);
		$prompttext = 'Summarize this for a second-grade student:\n\n'.$content_rewrite;
		
				  $curl = curl_init();
				  curl_setopt_array($curl, array(
				  CURLOPT_URL => 'https://api.openai.com/v1/completions',
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => '',
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 0,
				  CURLOPT_FOLLOWLOCATION => true,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => 'POST',
				  CURLOPT_POSTFIELDS =>'{
				  "model": "text-davinci-002",
				  "prompt": "'.$prompttext.'",
				  "temperature": 0.7,
				  "max_tokens": 2000,
				  "top_p": 1,
				  "frequency_penalty": 0,
				  "presence_penalty": 0
				}',
				  CURLOPT_HTTPHEADER => array(
					'Content-Type: application/json',
					'Authorization: Bearer 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'
				  ),
				));

				$response = curl_exec($curl);

				curl_close($curl);
				
				//echo $response; exit; 
				
				if(!empty($response)){
					
					$response = json_decode($response,true);
 					
					if(isset($response['choices'][0]['text']))
					{
						echo $response['choices'][0]['text'];
					}else{
						echo 'No content found!';
					}
				}else{
					echo 'No content found!';
				}
		}
	}
	
	
	public function mb_ord($char, $encoding = 'UTF-8') {
        if ($encoding === 'UCS-4BE') {
            list(, $ord) = (strlen($char) === 4) ? @unpack('N', $char) : @unpack('n', $char);
            return $ord;
        } else {
            return $this->mb_ord(mb_convert_encoding($char, 'UCS-4BE', $encoding), 'UCS-4BE');
        }
    }

    public function mb_htmlentities($string, $hex = true, $encoding = 'UTF-8') {
        return preg_replace_callback('/[\x{80}-\x{10FFFF}]/u', function ($match) use ($hex) {
            return sprintf($hex ? '&#x%X;' : '&#%d;', $this->mb_ord($match[0]));
        }, $string);
    }

    public function convert_emoji($str) {
        return preg_replace_callback("/[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0077}\x{E006C}\x{E0073}\x{E007F})|[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0073}\x{E0063}\x{E0074}\x{E007F})|[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0065}\x{E006E}\x{E0067}\x{E007F})|[\x{1F3F4}](?:\x{200D}\x{2620}\x{FE0F})|[\x{1F3F3}](?:\x{FE0F}\x{200D}\x{1F308})|[\x{0023}\x{002A}\x{0030}\x{0031}\x{0032}\x{0033}\x{0034}\x{0035}\x{0036}\x{0037}\x{0038}\x{0039}](?:\x{FE0F}\x{20E3})|[\x{1F441}](?:\x{FE0F}\x{200D}\x{1F5E8}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F466})|[\x{1F469}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F469})|[\x{1F469}\x{1F468}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F468})|[\x{1F469}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F48B}\x{200D}\x{1F469})|[\x{1F469}\x{1F468}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F48B}\x{200D}\x{1F468})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B0})|[\x{1F575}\x{1F3CC}\x{26F9}\x{1F3CB}](?:\x{FE0F}\x{200D}\x{2640}\x{FE0F})|[\x{1F575}\x{1F3CC}\x{26F9}\x{1F3CB}](?:\x{FE0F}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FF}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FE}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FD}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FC}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FB}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F9B8}\x{1F9B9}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F9DE}\x{1F9DF}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F46F}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93C}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FF}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FE}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FD}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FC}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FB}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F9B8}\x{1F9B9}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F9DE}\x{1F9DF}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F46F}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93C}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{200D}\x{2642}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2695}\x{FE0F})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FF})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FE})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FD})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FC})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FB})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F8}\x{1F1F9}\x{1F1FA}](?:\x{1F1FF})|[\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F0}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1FA}](?:\x{1F1FE})|[\x{1F1E6}\x{1F1E8}\x{1F1F2}\x{1F1F8}](?:\x{1F1FD})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F7}\x{1F1F9}\x{1F1FF}](?:\x{1F1FC})|[\x{1F1E7}\x{1F1E8}\x{1F1F1}\x{1F1F2}\x{1F1F8}\x{1F1F9}](?:\x{1F1FB})|[\x{1F1E6}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1ED}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F7}\x{1F1FB}](?:\x{1F1FA})|[\x{1F1E6}\x{1F1E7}\x{1F1EA}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FE}](?:\x{1F1F9})|[\x{1F1E6}\x{1F1E7}\x{1F1EA}\x{1F1EC}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F7}\x{1F1F8}\x{1F1FA}\x{1F1FC}](?:\x{1F1F8})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EB}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F0}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1F7})|[\x{1F1E6}\x{1F1E7}\x{1F1EC}\x{1F1EE}\x{1F1F2}](?:\x{1F1F6})|[\x{1F1E8}\x{1F1EC}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F3}](?:\x{1F1F5})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1EE}\x{1F1EF}\x{1F1F2}\x{1F1F3}\x{1F1F7}\x{1F1F8}\x{1F1F9}](?:\x{1F1F4})|[\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}](?:\x{1F1F3})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F4}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FF}](?:\x{1F1F2})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1EE}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1F1})|[\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1ED}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FD}](?:\x{1F1F0})|[\x{1F1E7}\x{1F1E9}\x{1F1EB}\x{1F1F8}\x{1F1F9}](?:\x{1F1EF})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EB}\x{1F1EC}\x{1F1F0}\x{1F1F1}\x{1F1F3}\x{1F1F8}\x{1F1FB}](?:\x{1F1EE})|[\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1ED})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EA}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}](?:\x{1F1EC})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F9}\x{1F1FC}](?:\x{1F1EB})|[\x{1F1E6}\x{1F1E7}\x{1F1E9}\x{1F1EA}\x{1F1EC}\x{1F1EE}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F7}\x{1F1F8}\x{1F1FB}\x{1F1FE}](?:\x{1F1EA})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1EE}\x{1F1F2}\x{1F1F8}\x{1F1F9}](?:\x{1F1E9})|[\x{1F1E6}\x{1F1E8}\x{1F1EA}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F8}\x{1F1F9}\x{1F1FB}](?:\x{1F1E8})|[\x{1F1E7}\x{1F1EC}\x{1F1F1}\x{1F1F8}](?:\x{1F1E7})|[\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F6}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}\x{1F1FF}](?:\x{1F1E6})|[\x{00A9}\x{00AE}\x{203C}\x{2049}\x{2122}\x{2139}\x{2194}-\x{2199}\x{21A9}-\x{21AA}\x{231A}-\x{231B}\x{2328}\x{23CF}\x{23E9}-\x{23F3}\x{23F8}-\x{23FA}\x{24C2}\x{25AA}-\x{25AB}\x{25B6}\x{25C0}\x{25FB}-\x{25FE}\x{2600}-\x{2604}\x{260E}\x{2611}\x{2614}-\x{2615}\x{2618}\x{261D}\x{2620}\x{2622}-\x{2623}\x{2626}\x{262A}\x{262E}-\x{262F}\x{2638}-\x{263A}\x{2640}\x{2642}\x{2648}-\x{2653}\x{2660}\x{2663}\x{2665}-\x{2666}\x{2668}\x{267B}\x{267E}-\x{267F}\x{2692}-\x{2697}\x{2699}\x{269B}-\x{269C}\x{26A0}-\x{26A1}\x{26AA}-\x{26AB}\x{26B0}-\x{26B1}\x{26BD}-\x{26BE}\x{26C4}-\x{26C5}\x{26C8}\x{26CE}-\x{26CF}\x{26D1}\x{26D3}-\x{26D4}\x{26E9}-\x{26EA}\x{26F0}-\x{26F5}\x{26F7}-\x{26FA}\x{26FD}\x{2702}\x{2705}\x{2708}-\x{270D}\x{270F}\x{2712}\x{2714}\x{2716}\x{271D}\x{2721}\x{2728}\x{2733}-\x{2734}\x{2744}\x{2747}\x{274C}\x{274E}\x{2753}-\x{2755}\x{2757}\x{2763}-\x{2764}\x{2795}-\x{2797}\x{27A1}\x{27B0}\x{27BF}\x{2934}-\x{2935}\x{2B05}-\x{2B07}\x{2B1B}-\x{2B1C}\x{2B50}\x{2B55}\x{3030}\x{303D}\x{3297}\x{3299}\x{1F004}\x{1F0CF}\x{1F170}-\x{1F171}\x{1F17E}-\x{1F17F}\x{1F18E}\x{1F191}-\x{1F19A}\x{1F201}-\x{1F202}\x{1F21A}\x{1F22F}\x{1F232}-\x{1F23A}\x{1F250}-\x{1F251}\x{1F300}-\x{1F321}\x{1F324}-\x{1F393}\x{1F396}-\x{1F397}\x{1F399}-\x{1F39B}\x{1F39E}-\x{1F3F0}\x{1F3F3}-\x{1F3F5}\x{1F3F7}-\x{1F3FA}\x{1F400}-\x{1F4FD}\x{1F4FF}-\x{1F53D}\x{1F549}-\x{1F54E}\x{1F550}-\x{1F567}\x{1F56F}-\x{1F570}\x{1F573}-\x{1F57A}\x{1F587}\x{1F58A}-\x{1F58D}\x{1F590}\x{1F595}-\x{1F596}\x{1F5A4}-\x{1F5A5}\x{1F5A8}\x{1F5B1}-\x{1F5B2}\x{1F5BC}\x{1F5C2}-\x{1F5C4}\x{1F5D1}-\x{1F5D3}\x{1F5DC}-\x{1F5DE}\x{1F5E1}\x{1F5E3}\x{1F5E8}\x{1F5EF}\x{1F5F3}\x{1F5FA}-\x{1F64F}\x{1F680}-\x{1F6C5}\x{1F6CB}-\x{1F6D2}\x{1F6E0}-\x{1F6E5}\x{1F6E9}\x{1F6EB}-\x{1F6EC}\x{1F6F0}\x{1F6F3}-\x{1F6F9}\x{1F910}-\x{1F93A}\x{1F93C}-\x{1F93E}\x{1F940}-\x{1F945}\x{1F947}-\x{1F970}\x{1F973}-\x{1F976}\x{1F97A}\x{1F97C}-\x{1F9A2}\x{1F9B0}-\x{1F9B9}\x{1F9C0}-\x{1F9C2}\x{1F9D0}-\x{1F9FF}]/u", function ($matches) {
            return '&#' . hexdec(bin2hex(mb_convert_encoding("$matches[0]", 'UTF-32', 'UTF-8'))) . ';';
        }, $str);
    }
}
