<?php

$params = require __DIR__ . '/sublevel.php';
$params = require __DIR__ . '/params.php';
$db = require __DIR__ . '/db.php';

$config = [
	'modules' => [
		'user' => [
			'class' => 'dektrium\user\Module',
			// 'enableUnconfirmedLogin' => true,
			'confirmWithin' => 21600,
			'cost' => 12,
			'admins' => ['admin'],
		],
	],
    'id' => 'basic',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
    'aliases' => [
        '@bower' => '@vendor/bower-asset',
        '@npm'   => '@vendor/npm-asset',
    ],
    'components' => [
        'request' => [
            // !!! insert a secret key in the following (if it is empty) - this is required by cookie validation
            'cookieValidationKey' => 'e13J6gs2KknrTRylUBFnIjEvPNkA6dk2',  
			'enableCookieValidation' => true,
			'enableCsrfValidation' => true
        ],
        'cache' => [
            'class' => 'yii\caching\FileCache',
        ],
        /*'user' => [
            'identityClass' => 'app\models\User',
            'enableAutoLogin' => true,
        ],*/
	'user' => [
          'identityClass' => 'app\models\User',
          'enableAutoLogin' => true,
           //'authTimeout' => 86400*6,  
      ],
       'session' => [
           'class' => 'yii\web\Session',
           'cookieParams' => ['httponly' => true, 'lifetime' => 86400 * 6],
           'timeout' => 86400*6, //session expire
           'useCookies' => true,
       ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
        'mailer' => [ 
			'class' => 'yii\swiftmailer\Mailer',				
			'transport' => [
				'class' => 'Swift_SmtpTransport',
				'host' => $params['smtp_host'],
                'username' => $params['smtp_username'],
                'password' => $params['smtp_password'],
				'port' => $params['smtp_port'],
				'encryption' => $params['smtp_encryption'],
            ],
		],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'db' => $db,
        
        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'rules' => [
				'defaultRoute' => 'user/security/login',
                'register'=>'user/registration/register',
				'login'=>'user/security/login',
                'my-template'=>'my-template/',
                'my-template/create'=>'my-template/create',
				'pricing'=>'my-template/pricing',
				'blackfriday'=>'my-template/blackfriday',
				'payment'=>'my-template/payment', 
				'fusionpayment'=>'my-template/fusionpayment', 
				'irpricing'=>'my-template/irpricing', 
				'rushlinqpayment'=>'my-template/rushlinqpayment', 
				'dashboard'=>'my-template/dashboard',
                'site/signout'=>'site/signout',
				'prospect'=>'my-template/prospect',
				'whitelabel'=>'whitelabel/', 
				//'prospect'=>'my-templatenew/prospect',
				'prospectnew'=>'my-templatenew/prospect',
				'integration'=>'my-template/integration',
				'profile-setting'=>'my-template/profile-setting', 
				'profileautowarmup'=>'my-template/profileautowarmup', 
				'profile-update'=>'my-template/profile-update',
				'prospector-settings'=>'my-template/prospector-settings',
				'csv_viewer'=>'my-template/csv_viewer',
				'webhooks/<id>'=>'webhooks',
				'createwebhook'=>'hooks/create',
            ],
        ],
		'assetManager' => [
            'appendTimestamp' => true,
        ],
		'mycomponent' => [
            'class' => 'app\components\MyComponent',
        ],
    ],
    'params' => $params,
];

if (YII_ENV_DEV) {
    // configuration adjustments for 'dev' environment
    $config['bootstrap'][] = 'debug';
    $config['modules']['debug'] = [
        'class' => 'yii\debug\Module',
        // uncomment the following to add your IP if you are not connecting from localhost.
        //'allowedIPs' => ['127.0.0.1', '::1'],
    ];

    $config['bootstrap'][] = 'gii';
    $config['modules']['gii'] = [
        'class' => 'yii\gii\Module',
        // uncomment the following to add your IP if you are not connecting from localhost.
        //'allowedIPs' => ['127.0.0.1', '::1'],
    ];
}

if (YII_ENV_PROD) {
    // configuration adjustments for 'dev' environment
    $config['bootstrap'][] = 'debug';
    $config['modules']['debug'] = [
        'class' => 'yii\debug\Module',
        // uncomment the following to add your IP if you are not connecting from localhost.
        //'allowedIPs' => ['127.0.0.1', '::1'],
    ];

    $config['bootstrap'][] = 'gii';
    $config['modules']['gii'] = [
        'class' => 'yii\gii\Module',
        // uncomment the following to add your IP if you are not connecting from localhost.
        //'allowedIPs' => ['127.0.0.1', '::1'],
    ];
}


return $config;
