<?php
/*
File Created on 26-02-2021
https://stackoverflow.com/questions/39137213/yii2-basic-how-i-use-common-function-functionality-in-yii2-action
*/
namespace app\components;

use Yii;
use yii\web\User;
use yii\base\Component;
use yii\base\InvalidConfigException;
use yii\data\Pagination;
use yii\db\Query;

class MyComponent extends Component
{
  public function MyFunction($param1,$param2){
    return $param1+$param2; // (:)
  }

	public function get_latest_subscription_OldBkpMethodBeforeAddOnPack($user_id=0){
		//$getLatestUserSubscription = Yii::$app->db->createCommand("select * from user_order_products where 2coSubscriptionStatus IS NOT NULL AND FIND_IN_SET (".$user_id.",user_ids) ORDER BY id DESC")->queryOne();
		//25-02-2021: before adding "Release & Attach Subscription" feature we assumed that the "latest subscription" would be "ORDER BY DESC LIMIT 1 of user_order_products table" as above commented query. But, after adding "Release & Attach Subscription" feature it is possible that "any subscription" can assign. So, below query added on 25-02-2021;
		
		$getUserSubscription = Yii::$app->db->createCommand("select * from user_order_products where 2coSubscriptionStatus ='ACTIVE' AND DATE(SubscriptionStartDate) <= DATE(NOW()) AND DATE(ExpirationDate) >= DATE(NOW()) AND FIND_IN_SET (".$user_id.",user_ids) ORDER BY id DESC")->queryOne();
		if(!empty($getUserSubscription)){
			return $getUserSubscription;
		}else{
			$getUserSubscription = Yii::$app->db->createCommand("select * from user_order_products where 2coSubscriptionStatus ='ACTIVE' AND FIND_IN_SET (".$user_id.",user_ids) ORDER BY id DESC")->queryOne();
			if(!empty($getUserSubscription)){
				return $getUserSubscription;
			}else{
				$getUserSubscription = Yii::$app->db->createCommand("select * from user_order_products where 2coSubscriptionStatus ='CANCELED' AND DATE(SubscriptionStartDate) <= DATE(NOW()) AND DATE(ExpirationDate) >= DATE(NOW()) AND FIND_IN_SET (".$user_id.",user_ids) ORDER BY id DESC")->queryOne();
				if(!empty($getUserSubscription)){
					return $getUserSubscription;
				}else{
					$getUserSubscription = Yii::$app->db->createCommand("select * from user_order_products where 2coSubscriptionStatus ='EXPIRED' AND DATE(SubscriptionStartDate) <= DATE(NOW()) AND DATE(ExpirationDate) >= DATE(NOW()) AND FIND_IN_SET (".$user_id.",user_ids) ORDER BY id DESC")->queryOne();
					if(!empty($getUserSubscription)){
						return $getUserSubscription;
					}else{
						$getUserSubscription = Yii::$app->db->createCommand("select * from user_order_products where 2coSubscriptionStatus IS NOT NULL AND FIND_IN_SET (".$user_id.",user_ids) ORDER BY id DESC")->queryOne();
						return $getUserSubscription;
					}
				}
			}
		}
	}

	public function get_latest_subscription($user_id=0){
		//$getLatestUserSubscription = Yii::$app->db->createCommand("select * from user_order_products where 2coSubscriptionStatus IS NOT NULL AND FIND_IN_SET (".$user_id.",user_ids) ORDER BY id DESC")->queryOne();
		//25-02-2021: before adding "Release & Attach Subscription" feature we assumed that the "latest subscription" would be "ORDER BY DESC LIMIT 1 of user_order_products table" as above commented query. But, after adding "Release & Attach Subscription" feature it is possible that "any subscription" can assign. So, below query added on 25-02-2021;
		
		$getUserSubscription = Yii::$app->db->createCommand("select * from user_order_products where isAddOnPackProduct=0 AND 2coSubscriptionStatus ='ACTIVE' AND DATE(SubscriptionStartDate) <= DATE(NOW()) AND DATE(ExpirationDate) >= DATE(NOW()) AND FIND_IN_SET (".$user_id.",user_ids) ORDER BY id DESC")->queryOne();
		if(!empty($getUserSubscription)){
			return $getUserSubscription;
		}else{
			$getUserSubscription = Yii::$app->db->createCommand("select * from user_order_products where isAddOnPackProduct=0 AND 2coSubscriptionStatus ='ACTIVE' AND FIND_IN_SET (".$user_id.",user_ids) ORDER BY id DESC")->queryOne();
			if(!empty($getUserSubscription)){
				return $getUserSubscription;
			}else{
				$getUserSubscription = Yii::$app->db->createCommand("select * from user_order_products where isAddOnPackProduct=0 AND 2coSubscriptionStatus ='CANCELED' AND DATE(SubscriptionStartDate) <= DATE(NOW()) AND DATE(ExpirationDate) >= DATE(NOW()) AND FIND_IN_SET (".$user_id.",user_ids) ORDER BY id DESC")->queryOne();
				if(!empty($getUserSubscription)){
					return $getUserSubscription;
				}else{
					$getUserSubscription = Yii::$app->db->createCommand("select * from user_order_products where isAddOnPackProduct=0 AND 2coSubscriptionStatus ='EXPIRED' AND DATE(SubscriptionStartDate) <= DATE(NOW()) AND DATE(ExpirationDate) >= DATE(NOW()) AND FIND_IN_SET (".$user_id.",user_ids) ORDER BY id DESC")->queryOne();
					if(!empty($getUserSubscription)){
						return $getUserSubscription;
					}else{
						$getUserSubscription = Yii::$app->db->createCommand("select * from user_order_products where isAddOnPackProduct=0 AND 2coSubscriptionStatus IS NOT NULL AND FIND_IN_SET (".$user_id.",user_ids) ORDER BY id DESC")->queryOne();
						return $getUserSubscription;
					}
				}
			}
		}
	}
	
function get_date_diff( $time1, $time2, $precision = 2 ) {
	// If not numeric then convert timestamps
	if( !is_int( $time1 ) ) {
		$time1 = strtotime( $time1 );
	}
	if( !is_int( $time2 ) ) {
		$time2 = strtotime( $time2 );
	}

	// If time1 > time2 then swap the 2 values
	if( $time1 > $time2 ) {
		list( $time1, $time2 ) = array( $time2, $time1 );
	}

	// Set up intervals and diffs arrays
	$intervals = array( 'year', 'month', 'day', 'hour', 'minute', 'second' );
	$diffs = array();

	foreach( $intervals as $interval ) {
		// Create temp time from time1 and interval
		$ttime = strtotime( '+1 ' . $interval, $time1 );
		// Set initial values
		$add = 1;
		$looped = 0;
		// Loop until temp time is smaller than time2
		while ( $time2 >= $ttime ) {
			// Create new temp time from time1 and interval
			$add++;
			$ttime = strtotime( "+" . $add . " " . $interval, $time1 );
			$looped++;
		}

		$time1 = strtotime( "+" . $looped . " " . $interval, $time1 );
		$diffs[ $interval ] = $looped;
	}

	$count = 0;
	$times = array();
	foreach( $diffs as $interval => $value ) {
		// Break if we have needed precission
		if( $count >= $precision ) {
			break;
		}
		// Add value and interval if value is bigger than 0
		if( $value > 0 ) {
			if( $value != 1 ){
				$interval .= "s";
			}
			// Add value and interval to times array
			$times[] = $value . " " . $interval;
			$count++;
		}
	}

	// Return string with times
	return implode( ", ", $times );
}

	public function getCurrentSubscriptionBySublevel($user_id=0,$sublevel=0){
		//note: as sublevel 1 to 6, are using for both non-blackfriday plans and blackfriday plans. This method finds, either current sublevel is for non-blackfriday plan or blackfriday plan.

				//18-05-2021 starts
		$plan_array = array('LFPM'=>'Professional Monthly','LFPQ'=>'Professional Quarterly','LFGM'=>'Grow Monthly','LFGQ'=>'Grow Quarterly','LFUM'=>'Ultimate Monthly','LFUQ'=>'Ultimate Quarterly',
				'LFPSAR'=>'Professional Semi-Annually','LFPA'=>'Professional Annually','LFGSAR'=>'Grow Semi-Annually','LFGA'=>'Grow Annually','LFUSAR'=>'Ultimate Semi-Annually','LFUA'=>'Ultimate Annually',
				'LFPSA'=>'Professional Semi Annual Black Friday Deal','LFPABF'=>'Professional Annual Black Friday Plan','LFGSA'=>'Grow Semi-Annual Black Friday Plan','LFGABF'=>'Grow Annual Black Friday Plan','LFUSA'=>'Ultimate Semi-Annual Black Friday Plan','LFUABF'=>'Ultimate Annual Black Friday Plan');

		$SublevelOneToSix_BlackFridayPlan_Arr =  array('1'=>'LFPSA','2'=>'LFPABF','3'=>'LFGSA','4'=>'LFGABF','5'=>'LFUSA','6'=>'LFUABF');
		$SublevelOneToSix_NonBlackFridayPlan_Arr =  array('1'=>'LFPM','2'=>'LFPQ','3'=>'LFGM','4'=>'LFGQ','5'=>'LFUM','6'=>'LFUQ');
				
				$plan_name = '';
				if($sublevel>=1 && $sublevel<=6){
					
					//non-blackfriday starts
					if($sublevel==1){
						$plan_name = "Professional Monthly";
					}elseif($sublevel==2){
						$plan_name = "Professional Quarterly";
					}elseif($sublevel==3){
						$plan_name = "Grow Monthly";
					}elseif($sublevel==4){
						$plan_name = "Grow Quarterly";
					}elseif($sublevel==5){
						$plan_name = "Ultimate Monthly";
					}elseif($sublevel==6){
						$plan_name = "Ultimate Quarterly";
					}
					//non-blackfriday ends
					
					$product_id = $SublevelOneToSix_NonBlackFridayPlan_Arr[$sublevel];//non-blackfriday product_id
					
					
					$chk_uop = Yii::$app->db->createCommand("select id,product_id from user_order_products where FIND_IN_SET (".$user_id.",user_ids) and product_id = '".$product_id."'  and `2coSubscriptionStatus` = 'ACTIVE' AND DATE(ExpirationDate) >= DATE(NOW()) order by id desc")->queryOne();
					if(!empty($chk_uop)){
						//non-blackfriday plan is current subscription.
					}else{
						
						$chk_uop = Yii::$app->db->createCommand("select id,product_id from user_order_products where FIND_IN_SET (".$user_id.",user_ids) and product_id = '".$product_id."'  and `2coSubscriptionStatus` = 'ACTIVE' order by id desc")->queryOne();
						if(!empty($chk_uop)){
							//non-blackfriday plan is current subscription.
						}else{

							$product_id = $SublevelOneToSix_BlackFridayPlan_Arr[$sublevel];//blackfriday product_id
							
							$chk_uop = Yii::$app->db->createCommand("select id,product_id from user_order_products where FIND_IN_SET (".$user_id.",user_ids) and product_id = '".$product_id."'  and `2coSubscriptionStatus` = 'ACTIVE' AND DATE(ExpirationDate) >= DATE(NOW()) order by id desc")->queryOne();
							if(!empty($chk_uop)){
								//blackfriday plan is current subscription.
								$plan_name = $plan_array[$chk_uop['product_id']];
							}else{
								
								$chk_uop = Yii::$app->db->createCommand("select id,product_id from user_order_products where FIND_IN_SET (".$user_id.",user_ids) and product_id = '".$product_id."'  and `2coSubscriptionStatus` = 'ACTIVE' order by id desc")->queryOne();
								if(!empty($chk_uop)){
									//blackfriday plan is current subscription.
									$plan_name = $plan_array[$chk_uop['product_id']];
								}else{
									
									$chk_bf_cancel = Yii::$app->db->createCommand("select id,product_id,created_at from user_order_products where FIND_IN_SET (".$user_id.",user_ids) and product_id = '".$product_id."'  and `2coSubscriptionStatus` = 'CANCELED' AND DATE(ExpirationDate) >= DATE(NOW()) order by id desc")->queryOne();
									
									$product_id = $SublevelOneToSix_NonBlackFridayPlan_Arr[$sublevel];//non-blackfriday product_id
									
									$chk_nonbf_cancel = Yii::$app->db->createCommand("select id,product_id,created_at from user_order_products where FIND_IN_SET (".$user_id.",user_ids) and product_id = '".$product_id."'  and `2coSubscriptionStatus` = 'CANCELED' AND DATE(ExpirationDate) >= DATE(NOW()) order by id desc")->queryOne();
									
									if(!empty($chk_bf_cancel) && !empty($chk_nonbf_cancel)){
										$created_at_bf_cancel = strtotime($chk_bf_cancel['created_at']);
										$created_at_nonbf_cancel = strtotime($chk_nonbf_cancel['created_at']);
										
										if($created_at_bf_cancel > $created_at_nonbf_cancel){
											//blackfriday plan is current subscription.
											$plan_name = $plan_array[$chk_bf_cancel['product_id']];
										}else{
											//non-blackfriday plan is current subscription.
										}
									}elseif(!empty($chk_bf_cancel) && empty($chk_nonbf_cancel)){
										
										//blackfriday plan is current subscription.
										$plan_name = $plan_array[$chk_bf_cancel['product_id']];
										
									}elseif(empty($chk_bf_cancel) && !empty($chk_nonbf_cancel)){
										
										//non-blackfriday plan is current subscription.
										
									}
									
								}
								
							}
						
						}

					}
				}
				//18-05-2021 ends
		return $plan_name;
		
	}

}