<?php
/**
 * @link http://www.yiiframework.com/
 * @copyright Copyright (c) 2008 Yii Software LLC
 * @license http://www.yiiframework.com/license/
 */

namespace app\assets;

use yii\web\AssetBundle;

/**
 * @author Qiang Xue <qiang.xue@gmail.com>
 * @since 2.0
 */
class LeadfusionAsset extends AssetBundle
{
    public $basePath = '@webroot';
    public $baseUrl = '@web';
    public $css = [
        'https://fonts.googleapis.com/css?family=Rubik:300,400,500,600%7CIBM+Plex+Sans:300,400,500,600,700',
        'theme/vendors/css/vendors.min.css',
        'theme/vendors/css/charts/apexcharts.css',
        'theme/vendors/css/extensions/swiper.min.css',
        'theme/css/bootstrap.css',
        'theme/css/bootstrap-extended.css',
        'theme/css/colors.css',
        'theme/css/components.css',
        'theme/css/themes/dark-layout.css',
        'theme/css/themes/semi-dark-layout.css',
        'theme/css/core/menu/menu-types/vertical-menu.css',
        'theme/css/pages/dashboard-ecommerce.css',
        'theme/css/style.css'
    ];
    public $js = [
		'theme/vendors/js/vendors.min.js',
        'theme/fonts/LivIconsEvo/js/LivIconsEvo.tools.js',
        'theme/fonts/LivIconsEvo/js/LivIconsEvo.defaults.js',
        'theme/fonts/LivIconsEvo/js/LivIconsEvo.min.js',
        'theme/vendors/js/charts/apexcharts.min.js',
        'theme/vendors/js/extensions/swiper.min.js',
        'theme/js/scripts/configs/vertical-menu-light.js',
        'theme/js/core/app-menu.js',
        'theme/js/core/app.js',
        'theme/js/scripts/components.js',
        'theme/js/scripts/footer.js',
        'theme/js/scripts/pages/dashboard-ecommerce.js'

    ];
    public $depends = [
        'yii\web\YiiAsset',
        'yii\bootstrap\BootstrapAsset',
    ];


    public $jsOptions = array(
    'position' => \yii\web\View::POS_HEAD
	);
}
