<?php

class Zohocrm {

    function is_valid_token($instance_url, $access_token) {

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $instance_url . "/crm/v2/Contacts");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 0);
        $headers = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'X-Http-Method-Override: GET';
        $headers[] = 'Authorization: Zoho-oauthtoken ' . $access_token;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $datas = curl_exec($ch);
        curl_close($ch);

        $datas = json_decode($datas, true);

        if (isset($datas['code']) && $datas['code'] == "INVALID_TOKEN" && isset($datas['status']) && $datas['status'] == "error") {
            return false;
        }

        return true;
    }

    function create_record($obj, $data, $access_token, $instance_url) {

        $data = array("data" => array($data));
        $data = json_encode($data);
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $instance_url . "/crm/v2/" . $obj);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);


        $headers = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'Authorization: Zoho-oauthtoken ' . $access_token;
        //$headers[] = 'X-Http-Method-Override: GET';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $json_response = curl_exec($ch);



        $response = json_decode($json_response, true);


        if (curl_errno($ch)) {

            return curl_errno($ch);
        }

        return $response;
        curl_close($ch);
    }

    function update_record($obj, $id, $data, $access_token, $instance_url) {

        switch ($obj) {
            case "Accounts":
                $data['id'] = $id;
                break;
            case "Contacts":
                $data['id'] = $id;
                break;
			case "Leads":
                $data['id'] = $id;
                break;
        }


        $data = array("data" => array($data));
        $data = json_encode($data);
        echo $data;
        $ch = curl_init();
        curl_setopt_array($ch, array(
            //CURLOPT_URL => $instance_url."/crm/v2/".$obj."/".$id,
            CURLOPT_URL => $instance_url . "/crm/v2/" . $obj,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "PUT",
            CURLOPT_POSTFIELDS => $data,
            CURLOPT_HTTPHEADER => array(
                "Content-Type: application/json",
                "Authorization: Zoho-oauthtoken " . $access_token,
                "Cookie: snaptid=sac1prdc01wut05"
            ),
        ));

        $json_response = curl_exec($ch);
        $response = json_decode($json_response, true);
        return $response;
        if (curl_errno($ch)) {
            return curl_error($ch);
        }
        curl_close($ch);
    }

    function get_formated_data_to_save($obj, $data_to_format, $array_format) {
        $finaldata = [];
        foreach ($data_to_format as $key => $value) {
            foreach ($array_format as $k => $cnt) {
                if ($key == $cnt) {
                    $finaldata[$k] = $value;
                    $custom_initials = array("lcf_", "ccf_", "acf_");
                    foreach ($custom_initials as $custom_initial) {
                        if (strstr($k, $custom_initial)) {
                            $updated_key = "custom." . $k;
                            $finaldata[$updated_key] = $value;
                            unset($finaldata[$k]);
                        }
                    }
                }
            }
        }
        return $finaldata;
    }

    function is_record_exist($sobj, $field, $value, $access_token, $instance_url) {

        $ch = curl_init();
        //curl_setopt($ch, CURLOPT_URL, $instance_url.'/crm/v2/'.$sobj.'/search?'.$field.'='.$value);
        curl_setopt($ch, CURLOPT_URL, $instance_url . '/crm/v2/' . $sobj . '/search?criteria=(' . $field . ':equals:' . $value . ')');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

        $headers = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'X-Http-Method-Override: GET';
        $headers[] = 'Authorization: Zoho-oauthtoken ' . $access_token;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $json_response = curl_exec($ch);



        if (curl_errno($ch)) {
            return array('totalSize' => 0);
        }

        $response = json_decode($json_response, true);
        if (!$response) {
            return array('totalSize' => 0);
        }

        if (isset($response['data'][0]['id']) && !empty($response['data'][0]['id'])) {
            $return_res['totalSize'] = 1;
        } else {
            return array('totalSize' => 0);
        }

        switch ($sobj) {
            case "Accounts":
                $return_res['records'][0]['Id'] = $response['data'][0]['id'];
                break;
            case "Contacts":
                $return_res['records'][0]['Id'] = $response['data'][0]['id'];
                break;
			case "Leads":
                $return_res['records'][0]['Id'] = $response['data'][0]['id'];
                break;
        }
        return $return_res;

        curl_close($ch);
    }

    function searcharray($obj, $value, $key, $array) {
        if (!empty($value)) {
            foreach ($array as $k => $val) {
                if ($obj == 'contact' && $key == "email") {
                    if (isset($val['emails'][0]['email']) && !empty($val['emails'][0]['email']) && $val['emails'][0]['email'] == $value) {
                        return $val['id'];
                    }
                    return false;
                }


                if (strtolower($val[$key]) == strtolower($value)) {

                    return $val['id'];
                }
            }
        }
        return false;
    }

    function get_custom_fields($sobj, $api_key) {


        switch ($sobj) {
            case "contact":
                $field_list = $this->contact_fields;
                break;
            case "account":
                $field_list = $this->company_fields;
                break;
			case "Leads":
                $field_list = $this->company_fields;
                break;
        }

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://api.close.com/api/v1/custom_field/" . $sobj . "/");

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        //curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_USERPWD, $api_key);

        $headers = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'X-Http-Method-Override: GET';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $datas = curl_exec($ch);

        $datas = json_decode($datas, true);

        if (curl_errno($ch)) {

            return false;
        }
        $fields = [];
        foreach ($datas['fields'] as $key => $data) {
            $fields[$key]['label'] = $data['name'];
            $fields[$key]['name'] = $data['id'];
        }

        return $fields;
        curl_close($ch);
    }

    function create_custom_field($obj, $data, $api_key) {

        $data = json_encode($data);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.close.com/api/v1/custom_field/' . $obj . '/');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_USERPWD, $api_key);

        $headers = array();
        $headers[] = 'Content-Type: application/json';
        //$headers[] = 'X-Http-Method-Override: GET';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $json_response = curl_exec($ch);
        $response = json_decode($json_response, true);
        return $response;
        if (curl_errno($ch)) {
            return curl_errno($ch);
        }
        curl_close($ch);
    }

    function create_default_activity_and_fields($api_key) {

        $data = ["name" => "Linkedin Message", "description" => "Linkedin Message", "api_create_only" => false];

        $data = json_encode($data);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.close.com/api/v1/custom_activity/');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_USERPWD, $api_key);

        $headers = array();
        $headers[] = 'Content-Type: application/json';
        //$headers[] = 'X-Http-Method-Override: GET';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $json_response = curl_exec($ch);
        $response = json_decode($json_response, true);

        if (curl_errno($ch)) {
            return curl_errno($ch);
        }
        curl_close($ch);

        $data = ["name" => "Linnkedin_Message", "type" => "text", "accepts_multiple_values" => false, "custom_activity_type_id" => $response['id']];
        $data = json_encode($data);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.close.com/api/v1/custom_field/activity/');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_USERPWD, 'api_5FdiNij0aDu63KpTJDJs6N.6bFytrGGxSIH1NPo56lSz4');

        $headers = array();
        $headers[] = 'Content-Type: application/json';
        //$headers[] = 'X-Http-Method-Override: GET';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $json_response = curl_exec($ch);
        $response1 = json_decode($json_response, true);

        if (curl_errno($ch)) {
            return curl_errno($ch);
        }
        curl_close($ch);

        $data = ["name" => "User Id", "type" => "text", "accepts_multiple_values" => false, "custom_activity_type_id" => $response['id']];

        $data = json_encode($data);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.close.com/api/v1/custom_field/activity/');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_USERPWD, 'api_5FdiNij0aDu63KpTJDJs6N.6bFytrGGxSIH1NPo56lSz4');

        $headers = array();
        $headers[] = 'Content-Type: application/json';
        //$headers[] = 'X-Http-Method-Override: GET';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $json_response = curl_exec($ch);
        $response2 = json_decode($json_response, true);

        if (curl_errno($ch)) {
            return curl_errno($ch);
        }
        curl_close($ch);

        $data = ["name" => "Lead Id", "type" => "text", "accepts_multiple_values" => false, "custom_activity_type_id" => $response['id']];
        //$data = json_encode($data);

        $data = json_encode($data);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.close.com/api/v1/custom_field/activity/');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_USERPWD, $api_key);

        $headers = array();
        $headers[] = 'Content-Type: application/json';
        //$headers[] = 'X-Http-Method-Override: GET';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $json_response = curl_exec($ch);
        $response2 = json_decode($json_response, true);

        if (curl_errno($ch)) {
            return curl_errno($ch);
        }
        curl_close($ch);
    }

    /*
      function searcharray($value, $key, $array) {
      foreach ($array as $k => $val) {
      if (strtolower($val[$key]) == strtolower($value)) {

      return $val['records'][0]['id'] = $val['id'];
      }
      }
      return null;
      }
     */

    /*
      function get_custom_fields($sobj, $api_key) {


      $company_array = array(array("name"=>"name","label"=>"Name"),array("name"=>"description","label"=>"Description"),array("name"=>"url","label"=>"Url"));
      $contact_array =array(array("name"=>"name","label"=>"Name"),array("name"=>"title","label"=>"Title"));
      $dataArray=[];

      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, "https://api.close.com/api/v1/custom_field/".$sobj."/");
      //curl_setopt($ch, CURLOPT_URL, "https://api.close.com/api/v1/custom_field/lead/");

      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
      curl_setopt($ch, CURLOPT_POST, 1);
      //curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
      curl_setopt($ch, CURLOPT_USERPWD, $api_key);

      $headers = array();
      $headers[] = 'Content-Type: application/json';
      $headers[] = 'X-Http-Method-Override: GET';
      curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

      $datas = curl_exec($ch);


      $datas = json_decode($datas,true);

      return $datas;
      }
     */

    function get_custom_field_list($sobj, $api_key) {




        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://api.close.com/api/v1/custom_field/" . $sobj . "/");

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        //curl_setopt($ch, CURLOPT_POSTFIELDS, $data); 
        curl_setopt($ch, CURLOPT_USERPWD, $api_key);

        $headers = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'X-Http-Method-Override: GET';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $datas = curl_exec($ch);


        $datas = json_decode($datas, true);

        if (curl_errno($ch)) {

            return false;
        }


        return $datas;
        curl_close($ch);
    }

    function get_lead_id_with_linkedin_uid($obj, $field, $value, $api_key) {


        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.close.com/api/v1/' . $obj . '/');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_USERPWD, $api_key);

        $headers = array();
        $headers[] = 'Content-Type: application/json';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $json_response = curl_exec($ch);



        if (curl_errno($ch)) {

            return array('totalSize' => 0);
        }


        $response = json_decode($json_response, true);

        $response = $response['data'];
        //return $response;

        $res = $this->search_lead_id_with_linkedin_uid_searcharray($obj, $value, $field, $response);

        if (!$res) {
            return array('totalSize' => 0);
        }
        $return_res['totalSize'] = 1;
        $return_res['records'][0] = $res;
        return $return_res;


        curl_close($ch);
    }

    function search_lead_id_with_linkedin_uid_searcharray($obj, $value, $key, $array) {
        if (!empty($value)) {
            foreach ($array as $k => $val) {
                if (isset($val[$key]) && strtolower($val[$key]) == strtolower($value)) {

                    return $val;
                }
            }
        }
        return false;
    }

    function check_is_custom_activity_exist($api_key) {

        $status = false;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://api.close.com/api/v1/custom_activity/");

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        //curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_USERPWD, $api_key);

        $headers = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'X-Http-Method-Override: GET';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $datas = curl_exec($ch);

        $datas = json_decode($datas, true);

        if (curl_errno($ch)) {

            $status = false;
        }
        if (isset($datas['data']) && !empty($datas['data'])) {
            foreach ($datas['data'] as $key => $data) {

                if ($data['name'] == "Linkedin Message") {
                    $status = true;
                }
            }
        }

        return $status;
        curl_close($ch);
    }

    function get_all_records($obj, $api_key) {

        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_URL => "https://api.na1.insightly.com/v3.0/Contacts",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "Content-Type: application/json",
                "Authorization: Basic " . $api_key,
                "Cookie: snaptid=sac1prdc01wut06"
            ),
        ));
        $json_response = curl_exec($ch);

        $response = json_decode($json_response, true);


        if (curl_errno($ch)) {
            return curl_errno($ch);
        }
        return $response;
        curl_close($ch);
    }

    function check_is_fullname_exist($sobj, $firstname, $lastname, $access_token, $instance_url) {

        $ch = curl_init();
        //curl_setopt($ch, CURLOPT_URL, $instance_url.'/crm/v2/'.$sobj.'/search?'.$field.'='.$value);
        curl_setopt($ch, CURLOPT_URL, $instance_url . '/crm/v2/' . $sobj . '/search?criteria=((Last_Name:equals:' . $lastname . ')and(First_Name:equals:' . $firstname . '))');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

        $headers = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'X-Http-Method-Override: GET';
        $headers[] = 'Authorization: Zoho-oauthtoken ' . $access_token;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $json_response = curl_exec($ch);

        if (curl_errno($ch)) {
            return array('totalSize' => 0);
        }

        $response = json_decode($json_response, true);

        if (!$response) {
            return array('totalSize' => 0);
        }

        if (isset($response['data'][0]['id']) && !empty($response['data'][0]['id'])) {
            $return_res['totalSize'] = 1;
        } else {
            return array('totalSize' => 0);
        }


        switch ($sobj) {
            case "Accounts":
                $return_res['records'][0]['Id'] = $response['data'][0]['id'];
                break;
            case "Contacts":
                $return_res['records'][0]['Id'] = $response['data'][0]['id'];
                break;
			case "Leads":
                $return_res['records'][0]['Id'] = $response['data'][0]['id'];
                break;
			 
        }
        return $return_res;

        curl_close($ch);
    }

    function create_note_to_contact($obj, $id, $data, $access_token, $instance_url) {

        $data = array("data" => array($data));
        $data = json_encode($data);
        $ch = curl_init();

		file_put_contents("zoho_leads_logs.txt","\r\nCreatenottocontact::".date('Y-m-d h:i:s')."\r\n",FILE_APPEND);
        curl_setopt($ch, CURLOPT_URL, $instance_url . "/crm/v2/" . $obj . '/' . $id . '/Notes');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);


        $headers = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'Authorization: Zoho-oauthtoken ' . $access_token;
        //$headers[] = 'X-Http-Method-Override: GET';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $json_response = curl_exec($ch);
        $response = json_decode($json_response, true);
		file_put_contents("zoho_leads_logs.txt","\r\nCreatenottocontactResponse::".date('Y-m-d h:i:s').'::'.print_r($response,true)."\r\n",FILE_APPEND);

        if (curl_errno($ch)) {

            return curl_errno($ch);
        }

        return $response;

        curl_close($ch);
    }

    function get_object_record($sobj, $field, $value, $access_token, $instance_url) {

        $ch = curl_init();
        //curl_setopt($ch, CURLOPT_URL, $instance_url.'/crm/v2/'.$sobj.'/search?'.$field.'='.$value);
        curl_setopt($ch, CURLOPT_URL, $instance_url . '/crm/v2/' . $sobj . '/search?criteria=(' . $field . ':equals:' . $value . ')');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

        $headers = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'X-Http-Method-Override: GET';
        $headers[] = 'Authorization: Zoho-oauthtoken ' . $access_token;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $json_response = curl_exec($ch);

        if (curl_errno($ch)) {
            return array('totalSize' => 0);
        }

        $response = json_decode($json_response, true);

        if (!$response) {
            return array('totalSize' => 0);
        }

        if (isset($response['data'][0]['id']) && !empty($response['data'][0]['id'])) {
            $return_res['totalSize'] = 1;
            switch ($sobj) {
                case "Accounts":
                    $return_res['records'] = $response['data'][0];
                    break;
                case "Contacts":
                    $return_res['records'] = $response['data'][0];
                    break;
				case "Leads":
					$return_res['records'] = $response['data'][0];
					break;
            }
            return $return_res;
        } else {
            return array('totalSize' => 0);
        }



        curl_close($ch);
    }

    /*
      function get_object_record($obj,$field,$value,$api_key){


      //return array('totalSize'=>0);

      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, 'https://api.na1.insightly.com/v3.1/'.$obj.'/Search?field_name='.$field.'&field_value='.$value.'&brief=false&count_total=false');
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
      curl_setopt($ch, CURLOPT_USERPWD, $api_key);

      $headers = array();
      $headers[] = 'Content-Type: application/json';
      $headers[] = 'X-Http-Method-Override: GET';
      $headers[] = 'Authorization: Basic '.$api_key;
      curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

      $json_response = curl_exec($ch);



      if (curl_errno($ch)) {

      return array('totalSize'=>0);
      }


      $response = json_decode($json_response, true);

      if(empty($response)){

      return array('totalSize'=>0);
      }
      $return_res['totalSize'] =1;

      switch ($obj) {
      case "Organisations":
      $return_res['records'] =$response[0];
      break;
      case "Contacts":
      $return_res['records'] =$response[0];
      break;
      }

      return $return_res;


      curl_close($ch);


      }

     */

    function get_object_record_with_fullname($obj, $first_name, $last_name, $api_key) {

        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_URL => "https://api.na1.insightly.com/v3.0/Contacts",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "Content-Type: application/json",
                "Authorization: Basic " . $api_key,
                "Cookie: snaptid=sac1prdc01wut06"
            ),
        ));
        $json_response = curl_exec($ch);

        $response = json_decode($json_response, true);


        if (curl_errno($ch)) {
            return array('totalSize' => 0);
        }

        curl_close($ch);
        if (!$response) {
            return array('totalSize' => 0);
        }

        if (isset($response) && !empty($response)) {
            foreach ($response as $value) {

                if (strtolower($value['FIRST_NAME']) == strtolower($first_name) && strtolower($value['LAST_NAME']) == strtolower($last_name)) {

                    $return_res['totalSize'] = 1;
                    $return_res['records'] = $value;

                    return $return_res;
                    //break;
                }
            }
        }

        return array('totalSize' => 0);
    }

    function regenerate_token($client_id, $client_secret, $refresh_token, $user_id, $con, $instance_url) {
        
//        $client_id = "1000.Z18RR3S288AKUH4HQB32XSTVBS8WVC";
//        $client_secret = "97917e323eab1e6271b20c559522471336cc9f090c";

        $instance = explode(".", $instance_url);
        $dd = end($instance);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://accounts.zoho.' . $dd . '/oauth/v2/token');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=refresh_token&client_id=" . $client_id . "&client_secret=" . $client_secret . "&refresh_token=" . $refresh_token . "&format=json");

        $headers = array();
        $headers[] = 'Content-Type: application/x-www-form-urlencoded';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($ch);
        $response = json_decode($result, true);

        if (curl_errno($ch)) {

            return curl_error($ch);
        }
        curl_close($ch);

//        $con->query("INSERT INTO error_handling (userId, response, request,mailSent) VALUES ('" . $user_id . "', '" . $result . "', 'In regenerate_token','1')");

        $dataArr = array();
        $dataArr['client_id'] = $client_id;
        $dataArr['client_secret'] = $client_secret;
        $dataArr['refresh_token'] = $refresh_token;
        $dataArr['instance_url'] = $instance_url;
        $dataArr['dd'] = $dd;

//        $con->query("INSERT INTO error_handling (userId, response, request,mailSent) VALUES ('" . $user_id . "', '" . json_encode($dataArr) . "', 'Data regenerate_token','1')");

        if (isset($response['access_token']) && !empty($response['access_token'])) {

            $sql = "UPDATE `crm_token` SET `zc_access_token` = '" . $response['access_token'] . "', `zc_token_type` = '" . $response['token_type'] . "', `zc_instance_url` = '" . $response['api_domain'] . "' WHERE `crm_token`.`user_id` = " . $user_id;
            if ($con->query($sql) === TRUE) {
                return $response['access_token'];
            } else {
                return false;
            }
            $conn->close();
        }
    }

    function is_token_expired($instance_url, $access_token) {

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $instance_url . "/crm/v2/Contacts");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 0);
        $headers = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'X-Http-Method-Override: GET';
        $headers[] = 'Authorization: Zoho-oauthtoken ' . $access_token;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $datas = curl_exec($ch);
        curl_close($ch);

        $datas = json_decode($datas, true);

        if (isset($datas['code']) && $datas['code'] == "INVALID_TOKEN" && isset($datas['status']) && $datas['status'] == "error") {
            return true;
        }

        return false;
    }

}
?>

