<?php

class Salesforce {

    //protected $contact_fields = ['FirstName','LastName','Email','AccountId','Org_Id__c','Email','Phone','Owner_Id__c','Website__c',"	Linkedin_Uid__c","Linkedin__c","Job_Title__c","Contact_Source__c","Contact_Assigned_By__c","Sequence_Name__c"];


    protected $company_fields = ['name', 'domain', "linkedin_company_page"];
    protected $contact_fields = ["first_name", "last_name", "linkedin_uid", "linkedin", "job_title", "contact_source", "contact_assigned_by", "sequence_name", "account_id", "org_id", "phone", "occupation"];

    function create_account($data, $instance_url, $access_token) {
        $url = "$instance_url/services/data/v54.0/sobjects/Account/";
        $data = json_encode($data);
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token",
            "Content-type: application/json"));

        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        $json_response = curl_exec($curl);
        $response = json_decode($json_response, true);
        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);

        //if ( $status != 201 ) {
        return $this->sendResponse($status, $response);
        //}

        curl_close($curl);

        //return $this->sendResponse($status, $json_response);
        //echo "HTTP status $status creating account<br/><br/>";
        //$response = json_decode($json_response, true);
        //$id = $response["id"];
        //echo "New record id $id<br/><br/>";
        //return $id;
    }

    function update_account($id, $data, $instance_url, $access_token) {

        $url = "$instance_url/services/data/v54.0/sobjects/Account/$id";

        $data = json_encode($data);

        $curl = curl_init($url);

        curl_setopt($curl, CURLOPT_HEADER, false);

        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token", "Content-type: application/json"));

        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PATCH");

        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);

        $json_response = curl_exec($curl);
        $response = json_decode($json_response, true);

        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);


        return $this->sendResponse($status, $response);

        if ($status != 204) {
            return $status;
        } else {
            return $json_response;
        }
    }

    function is_account_exist_with_domain($company_name, $instance_url, $access_token) {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, "$instance_url/services/data/v54.0/query/?q=SELECT+Id+FROM+Account+where+Name+like+'" . urlencode($company_name) . "'+LIMIT+1");
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token", "Content-type: application/json"));
        $result = curl_exec($curl);

        if (curl_errno($curl)) {
            return(curl_error($curl));
            //echo 'Error:' . curl_error($curl);
        }
        curl_close($curl);
        return json_decode($result, true);
    }

    function is_account_exist($company_name, $instance_url, $access_token) {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, "$instance_url/services/data/v54.0/query/?q=SELECT+Id+FROM+Account+where+Name+like+'" . urlencode($company_name) . "'+LIMIT+1");
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token", "Content-type: application/json"));
        $result = curl_exec($curl);

        if (curl_errno($curl)) {
            return(curl_error($curl));
            //echo 'Error:' . curl_error($curl);
        }
        curl_close($curl);
        return json_decode($result, true);
    }

    function create_contact($contact, $instance_url, $access_token) {
        $url = "$instance_url/services/data/v54.0/sobjects/Contact/";
        $contact = json_encode($contact);

        $curl = curl_init($url);

        curl_setopt($curl, CURLOPT_HEADER, false);

        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token",
            "Content-type: application/json"));

        curl_setopt($curl, CURLOPT_POST, true);

        curl_setopt($curl, CURLOPT_POSTFIELDS, $contact);

        $json_response = curl_exec($curl);
        $response = json_decode($json_response, true);

        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        return $response;

        //    if ( $status != 201 ) {
        //        die("Error: call to URL $url failed with status $status, response $json_response, curl_error " . curl_error($curl) . ", curl_errno " . curl_errno($curl));
        //    }
        //        echo "HTTP status $status creating contact<br/><br/>";

        curl_close($curl);

        //$response = json_decode($json_response, true);
        //return $json_response;
        //    print_r($response);
        //    $id = $response["id"];
        //    echo "New record id $id<br/><br/>";
        //    return $id;
    }

    function update_contact($id, $contact, $instance_url, $access_token) {

        $url = "$instance_url/services/data/v54.0/sobjects/Contact/$id";

        $contact = json_encode($contact);

        $curl = curl_init($url);

        curl_setopt($curl, CURLOPT_HEADER, false);

        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token", "Content-type: application/json"));

        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PATCH");

        curl_setopt($curl, CURLOPT_POSTFIELDS, $contact);

        $json_response = curl_exec($curl);
        $response = json_decode($json_response, true);

        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);


        //    if ( $status != 204 ) {
        //        die("Error: call to URL $url failed with status $status, response $json_response, curl_error " . curl_error($curl) . ", curl_errno " . curl_errno($curl));
        //    }
        //        echo "HTTP status $status updating contact<br/><br/>";
        //    curl_close($curl);
        //    $response = json_decode($json_response, true);
        //    print_r($response);
        //    $id = $response["id"];
        //     echo "Update record id $id<br/><br/>";
        //return $json_response;
        return $this->sendResponse($status, $response);

        if ($status != 204) {
            return $status;
        } else {
            return $json_response;
        }
    }

    function is_contact_exist($first_name, $last_name, $email, $instance_url, $access_token) {
        $curl = curl_init();
        //curl_setopt($curl, CURLOPT_URL, "$instance_url/services/data/v36.0/query/?q=SELECT+Id+FROM+Contact+WHERE+(FirstName+LIKE+'$first_name'+AND+LastName+LIKE+'$last_name')+OR+Email+LIKE+'$email'+LIMIT+1");
        curl_setopt($curl, CURLOPT_URL, "$instance_url/services/data/v54.0/query/?q=SELECT+Id+FROM+Contact+WHERE+FirstName+LIKE+'$first_name'+LIMIT+1");
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token", "Content-type: application/json"));
        $result = curl_exec($curl);

        if (curl_errno($curl)) {
            return(curl_error($curl));
            //echo 'Error:' . curl_error($curl);
        }
        curl_close($curl);
        return $result;
    }

    function is_contact_exist_by_firstname_and_lastname($first_name, $last_name, $instance_url, $access_token) {
        $curl = curl_init();
        //curl_setopt($curl, CURLOPT_URL, "$instance_url/services/data/v36.0/query/?q=SELECT+Id+FROM+Contact+WHERE+FirstName+LIKE+'$first_name'+AND+LastName+LIKE+'$last_name''+LIMIT+1");
        curl_setopt($curl, CURLOPT_URL, "$instance_url/services/data/v54.0/query/?q=SELECT+Id+FROM+Contact+WHERE+FirstName+LIKE+'" . urlencode($first_name) . "'+AND+LastName+LIKE+'" . urlencode($last_name) . "'+LIMIT+1");
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token", "Content-type: application/json"));
        $result = curl_exec($curl);

        if (curl_errno($curl)) {
            return(curl_error($curl));
            //echo 'Error:' . curl_error($curl);
        }
        curl_close($curl);
        return json_decode($result, true);
    }

    function is_contact_exist_by_email($email, $instance_url, $access_token) {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, "$instance_url/services/data/v54.0/query/?q=SELECT+Id+FROM+Contact+WHERE+Email+LIKE+'" . urlencode($email) . "'+LIMIT+1");

        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token", "Content-type: application/json"));
        $result = curl_exec($curl);
        // print_r($result);

        if (curl_errno($curl)) {
            return(curl_error($curl));
            //echo 'Error:' . curl_error($curl);
        }
        curl_close($curl);
        return json_decode($result, true);
    }

    function sendResponse($status, $result) {
        $response = [
            'status' => $status,
            'data' => $result
        ];

        return $response;
    }

    function get_refresh_token($client_id, $client_secret, $refresh_token) {

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://login.salesforce.com/services/oauth2/token');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=refresh_token&client_id=$client_id&client_secret= $client_secret&refresh_token=$refresh_token");

        $headers = array();
        $headers[] = 'Content-Type: application/x-www-form-urlencoded';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);


        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        return json_decode($result, true);
        curl_close($ch);
    }

    function is_token_expired($instance_url, $access_token) {

        $url = "https://" . $instance_url . "/services/data/v54.0/sobjects/Contact/listviews/";
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token"));
        $json_response = curl_exec($curl);
        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        $response = json_decode($json_response, true);
        if ($status != 200) {
            return true;
        }
        return false;
    }

    function regenerate_token($client_id, $client_secret, $refresh_token, $user_id, $con) {

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://login.salesforce.com/services/oauth2/token');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=refresh_token&client_id=" . $client_id . "&client_secret=" . $client_secret . "&refresh_token=" . $refresh_token . "&format=json");

        $headers = array();
        $headers[] = 'Content-Type: application/x-www-form-urlencoded';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);



        $result = curl_exec($ch);
        $response = json_decode($result, true);


        if (curl_errno($ch)) {
            return curl_error($ch);
        }

        curl_close($ch);


        if (isset($response['access_token']) && !empty($response['access_token'])) {

            $sql = "UPDATE `crm_token` SET `access_token` = '" . $response['access_token'] . "', `signature` = '" . $response['signature'] . "', `scope` = '" . $response['scope'] . "', `instance_url` = '" . $response['instance_url'] . "', `sid` = '" . $response['id'] . "', `issued_at` = '" . $response['issued_at'] . "' WHERE `crm_token`.`user_id` = " . $user_id;
            if ($con->query($sql) === TRUE) {
                return $response['access_token'];
            } else {
                return false;
            }
            $conn->close();
        }
    }

    function get_user_info($instance_url, $access_token) {

        //GET USERINFO LIKE EMAIL,USERNAME... ETC.
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://login.salesforce.com/id/00D2w00000Dqy52EAB/0052w000007GdLpAAK');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        $headers = array();
        $headers[] = 'X-Prettyprint: 1';
        $headers[] = 'Authorization: Bearer ' . $access_token;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);



        $result = curl_exec($ch);
        $result = json_decode($result, true);
        if (curl_errno($ch)) {
            return false;
        }
        return $result;
        curl_close($ch);
    }

    function get_custom_field_for_create($sobj, $instance_url, $access_token) {


        switch ($sobj) {
            case "contact":
                $field_list = $this->contact_fields;
                break;
            case "account":
                $field_list = $this->company_fields;
                break;
        }

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://" . $instance_url . "/services/data/v54.0/sobjects/" . $sobj . "/describe");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        $headers = array();
        $headers[] = 'X-Prettyprint: 1';
        $headers[] = 'Authorization: Bearer ' . $access_token;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);



        $datas = curl_exec($ch);
        //print_r($datas);
        $datas = json_decode($datas, true);
        if (curl_errno($ch)) {
            //print_r(curl_errno($ch));
            return false;
        }
        $fields = [];
        foreach ($datas['fields'] as $data) {

            $result[] = $data['name'];
        }

        print_r($result);

        $diff = array_diff($field_list, $result);
        return $diff;
        curl_close($ch);
    }

    function get_object_list($instance_url, $access_token) {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, "$instance_url/services/data/v54.0/query/?q=SELECT+SObjectType+FROM+ObjectPermissions+GROUP+BY+SObjectType+ORDER+BY+SObjectType+ASC");
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token", "Content-type: application/json"));
        $result = curl_exec($curl);


        if (curl_errno($curl)) {
            return(curl_error($curl));
        }
        curl_close($curl);
        $result = json_decode($result, true);

        $data = [];
        foreach ($result['records'] as $key => $value) {
            $data[] = $value['SobjectType'];
        }

        return $data;
    }

    function get_custom_fields($sobj, $instance_url, $access_token) {


        switch ($sobj) {
            case "Contact":
                $field_list = $this->contact_fields;
                break;
            case "Account":
                $field_list = $this->company_fields;
                break;
        }

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "$instance_url/services/data/v54.0/sobjects/$sobj/describe");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        $headers = array();
        $headers[] = 'X-Prettyprint: 1';
        $headers[] = 'Authorization: Bearer ' . $access_token;
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);



        $datas = curl_exec($ch);
        //print_r($datas); exit;
        $datas = json_decode($datas, true);
        if (curl_errno($ch)) {
            print_r(curl_errno($ch));
            return false;
        }
        $fields = [];
        foreach ($datas['fields'] as $key => $data) {

            //$fields[]=$data;
            $fields[$key]['label'] = $data['label'];
            $fields[$key]['name'] = $data['name'];
        }

        //print_r($fields);
        //$diff = array_diff( $field_list, $result);
        return $fields;
        curl_close($ch);
    }

    function create_record($obj, $data, $instance_url, $access_token) {
        $url = $instance_url . "/services/data/v54.0/sobjects/" . $obj . "/";
        $data = json_encode($data);
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token",
            "Content-type: application/json"));

        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        $json_response = curl_exec($curl);
        $response = json_decode($json_response, true);
        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);

        //if ( $status != 201 ) {
        return $this->sendResponse($status, $response);
        //}

        curl_close($curl);

        //return $this->sendResponse($status, $json_response);
        //echo "HTTP status $status creating account<br/><br/>";
        //$response = json_decode($json_response, true);
        //$id = $response["id"];
        //echo "New record id $id<br/><br/>";
        //return $id;
    }

    function update_record($obj, $id, $data, $instance_url, $access_token) {

        $url = $instance_url . "/services/data/v54.0/sobjects/" . $obj . "/" . $id;

        $data = json_encode($data);

        $curl = curl_init($url);

        curl_setopt($curl, CURLOPT_HEADER, false);

        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token", "Content-type: application/json"));

        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PATCH");

        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);

        $json_response = curl_exec($curl);
        $response = json_decode($json_response, true);

        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);


        return $this->sendResponse($status, $response);

        if ($status != 204) {
            return $status;
        } else {
            return $json_response;
        }
    }

    function get_formated_data_to_save($data_to_format, $array__format) {
        $finaldata = [];
        foreach ($data_to_format as $key => $value) {
            foreach ($array__format as $k => $cnt) {
                if ($key == $cnt) {
                    $finaldata[$k] = $value;
                }
            }
        }

        return $finaldata;
    }

    function add_note($data, $instance_url, $access_token) {
        $url = "$instance_url/services/data/v54.0/sobjects/Note/";
        $data = json_encode($data);
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token", "Content-type: application/json"));
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        $json_response = curl_exec($curl);
        $response = json_decode($json_response, true);
        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        if ($status != 201) {
            print($this->sendResponse($status, $response));
        }
        curl_close($curl);
        return $response;
    }

    function is_Response_Yes($instance_url, $access_token, $id, $contact) {
        $url = "$instance_url/services/data/v54.0/sobjects/Contact/$id";
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token", "Content-type: application/json"));
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PATCH");
        curl_setopt($curl, CURLOPT_POSTFIELDS, $contact);
        $json_response = curl_exec($curl);
        $response = json_decode($json_response, true);
        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        if ($status != 204) {
            return false;
        } else {
            return true;
        }
    }

}

?>
