<?php
header('Access-Control-Allow-Origin: *');

require_once '../../config.php';
require_once 'sfconfig.php';
require_once 'salesforce.php';

$sf = new Salesforce();

session_start();

$user_id = $_SESSION['userid'];
if (isset($_COOKIE['user_id_salesforce'])) {
    $user_id = $_COOKIE['user_id_salesforce'];
}
$base_url = "";
if (isset($_COOKIE['base_url'])) {
    $base_url = $_COOKIE['base_url'];
}
$token_url = LOGIN_URI . "/services/oauth2/token";

$code = $_GET['code'];

if (!isset($code) || $code == "") {

    die("Error - code parameter missing from request!");
}

$params = "code=" . $code
        . "&grant_type=authorization_code"
        . "&client_id=" . CLIENT_ID
        . "&client_secret=" . CLIENT_SECRET
        . "&redirect_uri=" . urlencode(REDIRECT_URI);

$curl = curl_init($token_url);

curl_setopt($curl, CURLOPT_HEADER, false);

curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

curl_setopt($curl, CURLOPT_POST, true);

curl_setopt($curl, CURLOPT_POSTFIELDS, $params);

$json_response = curl_exec($curl);

$status = curl_getinfo($curl, CURLINFO_HTTP_CODE);

if ($status != 200) {

    die("Error: call to token URL $token_url failed with status $status, response $json_response, curl_error " . curl_error($curl) . ", curl_errno " . curl_errno($curl));
}

curl_close($curl);

$response = json_decode($json_response, true);

$access_token = $response['access_token'];

$instance_url = $response['instance_url'];

if (!isset($access_token) || $access_token == "") {

    die("Error - access token missing from response!");
}

if (!isset($instance_url) || $instance_url == "") {

    die("Error - instance URL missing from response!");
}

$sf_user_id = '';
$sf_user_email = '';
$sf_user_name = '';
$user_info = $sf->get_user_info($response['id'], $access_token);

if (!$user_info == false) {
    $sf_user_id = $user_info['user_id'];
    $sf_user_name = $user_info['username'];
    $sf_user_email = $user_info['email'];
}
$conn = $con;

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $response['instance_url'] . "/services/data/v54.0/query/?q=SELECT+OrganizationType+FROM+Organization");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
$headers = array();
$headers[] = 'X-Prettyprint: 1';
$headers[] = 'Authorization: Bearer ' . $response['access_token'];
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
$datas = curl_exec($ch);
$datas = json_decode($datas, true);

if (!empty($datas) && isset($datas[0]['errorCode']) == 'API_DISABLED_FOR_ORG') {
    echo '<script>alert("Your salesforce account don\'t have an API access. Please enable it from your SalesForce account and try again.")</script>';
} else {
    if (!checkUserIdIsExist($user_id, $conn)) {

        $sql = "INSERT INTO `crm_token` (`user_id`, `access_token`, `refresh_token`, `signature`, `scope`, `id_token`, `instance_url`, `sid`, `token_type`, `issued_at`, `sf_user_id`, `sf_user_name`, `sf_user_email`,`status`) VALUES (" . $user_id . ", '" . $response['access_token'] . "', '" . $response['refresh_token'] . "','" . $response['signature'] . "', '" . $response['scope'] . "', '" . $response['id_token'] . "', '" . $response['instance_url'] . "', '" . $response['id'] . "', '" . $response['token_type'] . "', '" . $response['issued_at'] . "','" . $sf_user_id . "', '" . $sf_user_name . "', '" . $sf_user_email . "','1')";

        if ($conn->query($sql) === TRUE) {
            echo "New record created successfully";

            $default_data = '{"contact":{"FirstName":"first_name","LastName":"last_name","Email":"email"},"company":{"Name":"name","Domain__c":"domain"}}';

            $query = "INSERT INTO `crm_field_mapping` (`user_id`, `crm_name`, `mapping_fileds`) VALUES (" . $user_id . ", 'salesforce', '" . $default_data . "')";
            $conn->query($query);
        } else {
            echo "Error: " . $sql . "<br>" . $conn->error;
        }
        $conn->close();
    } else {

        $sql = "UPDATE `crm_token` SET `access_token` = '" . $response['access_token'] . "', `refresh_token` = '" . $response['refresh_token'] . "', `signature` = '" . $response['signature'] . "', `scope` = '" . $response['scope'] . "', `id_token` = '" . $response['id_token'] . "', `instance_url` = '" . $response['instance_url'] . "', `sid` = '" . $response['id'] . "', `issued_at` = '" . $response['issued_at'] . "' , `sf_user_id` = '" . $sf_user_id . "', `sf_user_name` = '" . $sf_user_name . "', `sf_user_email` = '" . $sf_user_email . "' WHERE `crm_token`.`user_id` = " . $user_id;
        if ($conn->query($sql) === TRUE) {
            echo "Record Updated successfully";
        } else {
            echo "Error: " . $sql . "<br>" . $conn->error;
        }
        $conn->close();
    }
}

function checkUserIdIsExist($user_id, $conn) {

    $sql = "SELECT * FROM `crm_token` WHERE user_id = $user_id";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        return true;
    } else {
        return false;
    }
}
?>

<script>
    document.addEventListener("DOMContentLoaded", function (event) {
        window.close("newwindow");
<?php if (!empty($base_url)) { ?>
            window.opener.location.href = '<?php echo $base_url; ?>';
<?php } else { ?>
            window.opener.location.reload();

<?php } ?>
    });
</script>
