<?php

session_start();

function show_accounts($instance_url, $access_token) {

   $query = "SELECT Name, Id from Account LIMIT 100";

   $url = "$instance_url/services/data/v20.0/query?q=" . urlencode($query);

   $curl = curl_init($url);

   curl_setopt($curl, CURLOPT_HEADER, false);

   curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

   curl_setopt($curl, CURLOPT_HTTPHEADER,

           array("Authorization: OAuth $access_token"));

   $json_response = curl_exec($curl);

   curl_close($curl);

   $response = json_decode($json_response, true);

   $total_size = $response['totalSize'];

   echo "$total_size record(s) returned<br/><br/>";

   foreach ((array) $response['records'] as $record) {

       echo $record['Id'] . ", " . $record['Name'] . "<br/>";

   }

   echo "<br/>";

}

function create_account($name, $instance_url, $access_token) {

   $url = "$instance_url/services/data/v20.0/sobjects/Account/";



   $content = json_encode(array("Name" => $name));

   $curl = curl_init($url);

   curl_setopt($curl, CURLOPT_HEADER, false);

   curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

   curl_setopt($curl, CURLOPT_HTTPHEADER,

           array("Authorization: OAuth $access_token",

               "Content-type: application/json"));

   curl_setopt($curl, CURLOPT_POST, true);

   curl_setopt($curl, CURLOPT_POSTFIELDS, $content);

   $json_response = curl_exec($curl);

   $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);

   if ( $status != 201 ) {

       die("Error: call to URL $url failed with status $status, response $json_response, curl_error " . curl_error($curl) . ", curl_errno " . curl_errno($curl));

   }

       echo "HTTP status $status creating account<br/><br/>";

   curl_close($curl);

   $response = json_decode($json_response, true);

   $id = $response["id"];

   echo "New record id $id<br/><br/>";

   return $id;

}

function show_account($id, $instance_url, $access_token) {

   $url = "$instance_url/services/data/v20.0/sobjects/Account/$id";



   $curl = curl_init($url);

   curl_setopt($curl, CURLOPT_HEADER, false);

   curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

   curl_setopt($curl, CURLOPT_HTTPHEADER,

           array("Authorization: OAuth $access_token"));

   $json_response = curl_exec($curl);

   $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);

   if ( $status != 200 ) {

       die("Error: call to URL $url failed with status $status, response $json_response, curl_error " . curl_error($curl) . ", curl_errno " . curl_errno($curl));

   }

   echo "HTTP status $status reading account<br/><br/>";

   curl_close($curl);

   $response = json_decode($json_response, true);

   foreach ((array) $response as $key => $value) {

       echo "$key:$value<br/>";

   }

   echo "<br/>";

}



function update_account($id, $new_name, $city, $instance_url, $access_token) {

   $url = "$instance_url/services/data/v20.0/sobjects/Account/$id";

   $content = json_encode(array("Name" => $new_name, "BillingCity" => $city));

   $curl = curl_init($url);

   curl_setopt($curl, CURLOPT_HEADER, false);

   curl_setopt($curl, CURLOPT_HTTPHEADER,

           array("Authorization: OAuth $access_token",

               "Content-type: application/json"));

   curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PATCH");

   curl_setopt($curl, CURLOPT_POSTFIELDS, $content);

   curl_exec($curl);

   $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);

   if ( $status != 204 ) {

       die("Error: call to URL $url failed with status $status, curl_error " . curl_error($curl) . ", curl_errno " . curl_errno($curl));

   }

   echo "HTTP status $status updating account<br/><br/>";

   curl_close($curl);

}

function delete_account($id, $instance_url, $access_token) {

   $url = "$instance_url/services/data/v20.0/sobjects/Account/$id";

   $curl = curl_init($url);

   curl_setopt($curl, CURLOPT_HEADER, false);

   curl_setopt($curl, CURLOPT_HTTPHEADER,

           array("Authorization: OAuth $access_token"));

   curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "DELETE");

   curl_exec($curl);

   $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);

   if ( $status != 204 ) {

       die("Error: call to URL $url failed with status $status, curl_error " . curl_error($curl) . ", curl_errno " . curl_errno($curl));

   }

   echo "HTTP status $status deleting account<br/><br/>";

   curl_close($curl);

}

function create_contact($contact, $instance_url, $access_token) {

   $url = "$instance_url/services/data/v20.0/sobjects/Contact/";
   $contact = json_encode($contact);

   $curl = curl_init($url);

   curl_setopt($curl, CURLOPT_HEADER, false);

   curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

   curl_setopt($curl, CURLOPT_HTTPHEADER,

           array("Authorization: OAuth $access_token",

               "Content-type: application/json"));

   curl_setopt($curl, CURLOPT_POST, true);

   curl_setopt($curl, CURLOPT_POSTFIELDS, $contact);

   $json_response = curl_exec($curl);

   $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);

//    if ( $status != 201 ) {

//        die("Error: call to URL $url failed with status $status, response $json_response, curl_error " . curl_error($curl) . ", curl_errno " . curl_errno($curl));

//    }

//        echo "HTTP status $status creating contact<br/><br/>";

   curl_close($curl);

   //$response = json_decode($json_response, true);
   print_r($json_response);
//    print_r($response);

//    $id = $response["id"];

//    echo "New record id $id<br/><br/>";

//    return $id;

}


function update_contact($id,$contact, $instance_url, $access_token) {
    
   $url = "$instance_url/services/data/v20.0/sobjects/Contact/$id";

   $contact = json_encode($contact);

   $curl = curl_init($url);

   curl_setopt($curl, CURLOPT_HEADER, false);

   curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

   curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token","Content-type: application/json"));

   curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PATCH");

   curl_setopt($curl, CURLOPT_POSTFIELDS, $contact);

   $json_response = curl_exec($curl);

   
    $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);

    
//    if ( $status != 204 ) {

//        die("Error: call to URL $url failed with status $status, response $json_response, curl_error " . curl_error($curl) . ", curl_errno " . curl_errno($curl));

//    }

//        echo "HTTP status $status updating contact<br/><br/>";

//    curl_close($curl);

//    $response = json_decode($json_response, true);
//    print_r($response);

//    $id = $response["id"];

//     echo "Update record id $id<br/><br/>";
    //return $json_response;
    
  echo $status;


}




function delete_contact($id, $instance_url, $access_token) {

   $url = "$instance_url/services/data/v20.0/sobjects/Contact/$id";

   $curl = curl_init($url);

   curl_setopt($curl, CURLOPT_HEADER, true);

   curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

   curl_setopt($curl, CURLOPT_HTTPHEADER,array("Authorization: OAuth $access_token","Content-type: application/json"));

   curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "DELETE");

   $json_response = curl_exec($curl);

   $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);

/*
   if ( $status != 204 ) {

       die("Error: call to URL $url failed with status $status, response $json_response, curl_error " . curl_error($curl) . ", curl_errno " . curl_errno($curl));

   }
   */

       echo "HTTP status $status deleting contact<br/><br/>";

   curl_close($curl);

   $response = json_decode($json_response, true);
   print_r($response);

   

   //echo "deleted record id $id<br/><br/>";

   //return $id;

}

function search_in_contact($string,$instance_url, $access_token){
    $result=[];
    //$q ='{"q":"ravi","fields" : ["firstName", "lastName"],"sobjects":[{"name": "Contact"}],"in":"ALL","overallLimit":100,"defaultLimit":10}';
    $q ='{"q":"Ravi","fields" : ["lastName"],"sobjects":[{"name": "Contact"}],"overallLimit":100,"defaultLimit":10}';
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, "$instance_url/services/data/v36.0/parameterizedSearch");
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POST, true);
    $post = $q;
    curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
    curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token","Content-type: application/json"));


    $result = curl_exec($curl);
   
    if (curl_errno($curl)) {
        return(curl_error($curl));
        echo 'Error:' . curl_error($curl);
    }
    curl_close($curl);

    //return count(json_decode($result,true));
    return $result;
}

function string_query($string, $instance_url, $access_token){
    $curl = curl_init();

    curl_setopt($curl, CURLOPT_URL, "$instance_url/services/data/v36.0/query/?q=SELECT+*+FROM+Contact+WHERE+(FirstName+LIKE+'Avi'+AND+LastName+LIKE+'Green')+OR+Email+LIKE+'jrogers@burlington.com'");
    //curl_setopt($curl, CURLOPT_URL, "$instance_url/services/data/v20.0/query/?q=SELECT FirstName FROM Contact");
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
    curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token","Content-type: application/json"));

    $result = curl_exec($curl);
    if (curl_errno($curl)) {
        return(curl_error($curl));
        echo 'Error:' . curl_error($curl);
    }
    curl_close($curl);
    return $result;
}

function is_contact_exist($first_name, $last_name, $email, $instance_url, $access_token){
    $curl = curl_init();

    curl_setopt($curl, CURLOPT_URL, "$instance_url/services/data/v36.0/query/?q=SELECT+Id+FROM+Contact+WHERE+(FirstName+LIKE+'$first_name'+AND+LastName+LIKE+'$first_name')+OR+Email+LIKE+'$email'+LIMIT+1");
    //curl_setopt($curl, CURLOPT_URL, "$instance_url/services/data/v20.0/query/?q=SELECT FirstName FROM Contact");
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
    curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token","Content-type: application/json"));

    $result = curl_exec($curl);
    if (curl_errno($curl)) {
        return(curl_error($curl));
        echo 'Error:' . curl_error($curl);
    }
    curl_close($curl);
    return $result;
}


function create_object1($object_name, $instance_url, $access_token){

	$data = ["Name"=>"Company1"];
	$data = json_encode($data);
	$curl = curl_init();
	
	curl_setopt($curl, CURLOPT_URL, "$instance_url/services/data/v20.0/sobjects/Company__c/");
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'POST');
	
	curl_setopt($curl, CURLOPT_HTTPHEADER, array("Authorization: OAuth $access_token","Content-type: application/json"));
	curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
	$result = curl_exec($curl);
	print_r($result);
	if (curl_errno($curl)) {
	    echo 'Error:' . curl_error($curl);
	}
	curl_close($curl);
}


function create_object($object_name, $instance_url, $access_token){
	$data = json_encode(array("Name"=>"Company", "Property_one__c"=> "value 1", "Property_two__c"=>"value 2"));
	//$data = "{ \\"Name\\": \\"Company\\", \\"Property_one__c\\": \\"value 1\\", \\"Property_two__c\\": \\"value 2\\"}";
	$ch = curl_init();

	curl_setopt($ch, CURLOPT_URL, "$instance_url/services/data/v20.0/sobjects/MyObject__c");
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

	$headers = array();
	$headers[] = "Content-Type: application/json";
	$headers[] = "Authorization: Bearer $access_token";
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	print_r($result);
	if (curl_errno($ch)) {
	    echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

}


function get_contact_fields($instance_url, $access_token){

  $url = "$instance_url/services/data/v28.0/search/layout/?q=Contact";

  $curl = curl_init($url);

  curl_setopt($curl, CURLOPT_HEADER, false);

  curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

  curl_setopt($curl, CURLOPT_HTTPHEADER,

          array("Authorization: OAuth $access_token"));

  $json_response = curl_exec($curl);

  $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);

  if ( $status != 200 ) {

      die("Error: call to URL $url failed with status $status, response $json_response, curl_error " . curl_error($curl) . ", curl_errno " . curl_errno($curl));

  }

  echo "HTTP status $status reading account<br/><br/>";

  curl_close($curl);

  //$response = json_decode($json_response, true);
  print_r($json_response);
}



           //echo $access_token = $_SESSION['access_token'];

           //echo $instance_url = $_SESSION['instance_url'];
	   /*
           if (!isset($access_token) || $access_token == "") {

               die("Error - access token missing from session!");

           }

           if (!isset($instance_url) || $instance_url == "") {

               die("Error - instance URL missing from session!");

           }

           show_accounts($instance_url, $access_token);

           $id = create_account("My New Org", $instance_url, $access_token);

           show_account($id, $instance_url, $access_token);

           show_accounts($instance_url, $access_token);

           update_account($id, "My New Org, Inc", "San Francisco",

                   $instance_url, $access_token);

           show_account($id, $instance_url, $access_token);

           show_accounts($instance_url, $access_token);

           delete_account($id, $instance_url, $access_token);

           show_accounts($instance_url, $access_token);
           
           
	    */
	    
	    
	    
	    // $id='0032w00000Ki7JQAAZ';
	     //$data = ["FirstName"=>"Ravi","LastName"=>"Bhuva"];
	     //$id = create_contact($data, $instance_url, $access_token);
	     //print_r($id);
	     
	     //create_object('Company', $instance_url, $access_token);
?>

       
