<?php

//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);
header("Access-Control-Allow-Origin:*");
header("Access-Control-Allow-Credentials:true");
header("Access-Control-Allow-Methods: OPTIONS, GET, POST");
header("Access-Control-Allow-Headers: Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");
$GLOBALS['httpcode'] = '';
$message = array(); // To store the message of responses

function unicodeString($str, $encoding = null) {
    if (is_null($encoding))
        $encoding = ini_get('mbstring.internal_encoding');
    return preg_replace_callback('/u([0-9a-fA-F]{4})/u', function($match) use ($encoding) {
        return mb_convert_encoding(pack('H*', $match[1]), $encoding, 'UTF-16BE');
    }, $str);
}

if (isset($_POST)) {
    $proxyIp = "brd.superproxy.io";
$proxyPort = "22225";
$proxyUsername = "brd-customer-hl_5b864891-zone-hubspotapi";
$proxyPassword = "qjuurxof7nyi";

    $hsApiKey = $_POST['hsApiKey'];
    $hsPortalId = $_POST['hsPortalId'];
    $owID = $_POST['owID'];

    $data = $_POST['data'];
    $basicInfo = $_POST['data']['basicInfo'];
    $basicInfoData = json_decode($basicInfo, true);

    $contactInfo = $_POST['data']['contactInfo'];
    $contactInfoData = json_decode($contactInfo, true);

    $company_detail = $_POST['data']['company_detail'];
    $company_detailData = json_decode($company_detail, true);

    // Contact Information    
    $firstName = unicodeString($basicInfoData['firstName']);
    $lastName = unicodeString($basicInfoData['lastName']);
    $email = "";
    if (isset($contactInfoData['emailAddress'])) {
        if ($contactInfoData['emailAddress'] != "NA" && $contactInfoData['emailAddress'] != "N/A") {
            $email = $contactInfoData['emailAddress'];
        }
    }
    $phone = "";
    if (isset($contactInfoData['phoneNumbers'])) {
        if (isset($contactInfoData['phoneNumbers'][0]['number']) && $contactInfoData['phoneNumbers'][0]['number'] != "NA" && $contactInfoData['phoneNumbers'][0]['number'] != "N/A") {
            $phone = $contactInfoData['phoneNumbers'][0]['number'];
        }
    }

    $linkedin_uid = $data['linkedinpublicid'];
    $linkedin = "https://www.linkedin.com/in/" . $data['url_publicIdentifier'];
    $occupation = $basicInfoData['occupation'];
    $sitetitle_seq = $_POST['sitetitle_seq'];
    $seq_name = $data['seq_name'];
    $contact_assigned_by = $_POST['contact_assigned_by'];
    $contact_source = "linkedin";

    //Company Information    
    $name = unicodeString($company_detailData['companyName']);
    $linkedin_company_page = $company_detailData['url'];
    $website = $company_detailData['companyPageUrl'];
    $domain = $company_detailData['companyPageUrl'];
    $industry = $company_detailData['industries'];

    //Messages
    $msgs = $_POST['msgs'];

    function SetDomain() {
        if (isset($GLOBALS['domain']) && $GLOBALS['domain'] != '') {
            $domain = parse_url($GLOBALS['domain'], PHP_URL_HOST);

            if ($domain == "") {
                $domain = $GLOBALS['domain'];
            }
            return $domain;
        }
        return '';
    }

    $domain = SetDomain();

    function CheckCompany($domain) {
        $proxyIp = $GLOBALS['proxyIp'];
        $proxyPort = $GLOBALS['proxyPort'];
        $proxyUsername = $GLOBALS['proxyUsername'];
        $proxyPassword = $GLOBALS['proxyPassword'];
        $data = array();
        $data['filterGroups'] = [array("filters" => array(["propertyName" => "domain", "operator" => "EQ", "value" => $domain]))];
        $data['sorts'] = ["sorts"];
        $data['limit'] = 1;
        $data['after'] = 0;
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.hubapi.com/crm/v3/objects/companies/search?hapikey=" . $GLOBALS['hsApiKey'],
            CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_PROXY => "$proxyIp",
            CURLOPT_PROXYPORT => "$proxyPort",
            CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array(
                "Content-Type: application/json"
            ),
        ));

        $searchresponse = curl_exec($curl);
        $curlError = curl_error($curl);
        curl_close($curl);
        if (empty($curlError)) {
            $comppany = json_decode($searchresponse);
            if (!isset($comppany->status)) {
                if ($comppany->total == 0) {
                    CreateNewComapny();
                } else {
                    UpdateCompany($comppany->results[0]->id);
                }
            }
        }
    }

    function CreateNewComapny() {
//        echo "create company";
        $proxyIp = $GLOBALS['proxyIp'];
        $proxyPort = $GLOBALS['proxyPort'];
        $proxyUsername = $GLOBALS['proxyUsername'];
        $proxyPassword = $GLOBALS['proxyPassword'];
        $data = array();
        $data['properties'] = array("domain" => $GLOBALS['domain'], "name" => $GLOBALS['name'], "hubspot_owner_id" => $GLOBALS['owID'], "linkedin_company_page" => $GLOBALS['linkedin_company_page']);

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, "https://api.hubapi.com/crm/v3/objects/companies?hapikey=" . $GLOBALS['hsApiKey']);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_PROXY, "$proxyIp");
        curl_setopt($curl, CURLOPT_PROXYPORT, "$proxyPort");
        curl_setopt($curl, CURLOPT_PROXYUSERPWD, "$proxyUsername:$proxyPassword");
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($curl, CURLOPT_HTTPHEADER, array("content-type: application/json"));

        $createresponse = curl_exec($curl);
        $err = curl_error($curl);
        $GLOBALS['httpcode'] = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
        if ($err || (isset(json_decode($createresponse)->status) && json_decode($createresponse)->status == 'error')) {
            $message['errorMessage'] = "Something went wrong while Creating Company";
        } else {
            global $message;
            $message['companyId'] = json_decode($createresponse)->id;
            $message['companyStatus'] = "New Company";
        }
    }

    function UpdateCompany($compId) {
//        echo "update company";
        $proxyIp = $GLOBALS['proxyIp'];
        $proxyPort = $GLOBALS['proxyPort'];
        $proxyUsername = $GLOBALS['proxyUsername'];
        $proxyPassword = $GLOBALS['proxyPassword'];
        $data = array();
        $data['properties'] = array("domain" => $GLOBALS['domain'], "name" => $GLOBALS['name'], "hubspot_owner_id" => $GLOBALS['owID'], "linkedin_company_page" => $GLOBALS['linkedin_company_page']);
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, 'https://api.hubapi.com/crm/v3/objects/companies/' . $compId . '?hapikey=' . $GLOBALS['hsApiKey']);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'PATCH');
        curl_setopt($curl, CURLOPT_PROXY, "$proxyIp");
        curl_setopt($curl, CURLOPT_PROXYPORT, "$proxyPort");
        curl_setopt($curl, CURLOPT_PROXYUSERPWD, "$proxyUsername:$proxyPassword");
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));

        $headers = array();
        $headers[] = 'Content-Type: application/json';
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

        $updateresponse = curl_exec($curl);
        $err = curl_error($curl);
        $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        $GLOBALS['httpcode'] = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
        if ($err || (isset(json_decode($updateresponse)->status) && json_decode($updateresponse)->status == 'error')) {
            $message['errorMessage'] = "Something went wrong while Updating Company";
        } else {
            global $message;
            $message['companyId'] = json_decode($updateresponse)->id;
            $message['companyStatus'] = "Existing Company";
        }
    }

    function CheckContact() {
//        echo "check contact";
        $proxyIp = $GLOBALS['proxyIp'];
        $proxyPort = $GLOBALS['proxyPort'];
        $proxyUsername = $GLOBALS['proxyUsername'];
        $proxyPassword = $GLOBALS['proxyPassword'];
        $data = array();
        if (!empty($GLOBALS['email'])) {
            $data['filterGroups'] = [array("filters" => array(["propertyName" => "email", "operator" => "EQ", "value" => $GLOBALS['email']]))];
        } else {
            $data['filterGroups'] = [array("filters" => array(["propertyName" => "firstname", "operator" => "EQ", "value" => $GLOBALS['firstName']], ["propertyName" => "lastname", "operator" => "EQ", "value" => $GLOBALS['lastName']]))];
        }

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.hubapi.com/crm/v3/objects/contacts/search?hapikey=' . $GLOBALS['hsApiKey'],
            CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_POST => 1,
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_PROXY => "$proxyIp",
            CURLOPT_PROXYPORT => "$proxyPort",
            CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
            CURLOPT_HTTPHEADER => array(
                "content-type: application/json"
            ),
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        $GLOBALS['httpcode'] = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
        if ($err || (isset(json_decode($response)->status) && json_decode($response)->status == 'error')) {
            $message['errorMessage'] = "Something went wrong while Checking Contact";
        } else {
            $res = json_decode($response);
            if (isset($res->total) && $res->total > 0) {
                $_POST['vid'] = $vid = $res->results[0]->id;
                UpdateContact($_POST['vid']);
            } else {
                CreateNewContact();
            }
        }
    }

    function UpdateContact() {
//        echo "update Contact";
        $proxyIp = $GLOBALS['proxyIp'];
        $proxyPort = $GLOBALS['proxyPort'];
        $proxyUsername = $GLOBALS['proxyUsername'];
        $proxyPassword = $GLOBALS['proxyPassword'];
        $data = array();
        if (isset($GLOBALS['email']) && $GLOBALS['email'] != '') {
            $data['properties'] = array("firstname" => $GLOBALS['firstName'], "lastname" => $GLOBALS['lastName'], "phone" => $GLOBALS['phone'], "website" => $GLOBALS['domain'], "company" => $GLOBALS['name'], "linkedin_uid" => $GLOBALS['linkedin_uid'], "linkedin" => $GLOBALS['linkedin'], "email" => $GLOBALS['email'], "hubspot_owner_id" => $GLOBALS['owID'], "jobtitle" => $GLOBALS['occupation'], "contact_source" => "LinkedIn", "contact_assigned_by" => $GLOBALS['contact_assigned_by'], $GLOBALS['sitetitle_seq'] => $GLOBALS['seq_name']);
        } else {
            $data['properties'] = array("firstname" => $GLOBALS['firstName'], "lastname" => $GLOBALS['lastName'], "phone" => $GLOBALS['phone'], "website" => $GLOBALS['domain'], "company" => $GLOBALS['name'], "linkedin_uid" => $GLOBALS['linkedin_uid'], "linkedin" => $GLOBALS['linkedin'], "hubspot_owner_id" => $GLOBALS['owID'], "jobtitle" => $GLOBALS['occupation'], "contact_source" => "LinkedIn", "contact_assigned_by" => $GLOBALS['contact_assigned_by'], $GLOBALS['sitetitle_seq'] => $GLOBALS['seq_name']);
        }

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, 'https://api.hubapi.com/crm/v3/objects/contacts/' . $_POST['vid'] . '?hapikey=' . $GLOBALS['hsApiKey']);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'PATCH');
        curl_setopt($curl, CURLOPT_PROXY, "$proxyIp");
        curl_setopt($curl, CURLOPT_PROXYPORT, "$proxyPort");
        curl_setopt($curl, CURLOPT_PROXYUSERPWD, "$proxyUsername:$proxyPassword");
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
        $headers = array();
        $headers[] = 'Content-Type: application/json';
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

        $updateresponse = curl_exec($curl);
        $err = curl_error($curl);
        $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        $GLOBALS['httpcode'] = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
        if ($err || (isset(json_decode($updateresponse)->status) && json_decode($updateresponse)->status == 'error')) {
            $message['errorMessage'] = "Something went wrong while Updating Contact";
        } else {
            global $message;
            $message['status'] = "Updated";
            InsertMessage();
            $message['mess'] = '<a target="_blank" href="https://app.hubspot.com/sales/' . $GLOBALS['hsPortalId'] . '/contact/' . $_POST['vid'] . '/">Contact</a>&nbsp has been ' . $message['status'];
        }
    }

    function CreateNewContact() {
//        echo "create Contact";
        $proxyIp = $GLOBALS['proxyIp'];
        $proxyPort = $GLOBALS['proxyPort'];
        $proxyUsername = $GLOBALS['proxyUsername'];
        $proxyPassword = $GLOBALS['proxyPassword'];
        $data = array();

        if (isset($GLOBALS['email']) && $GLOBALS['email'] != '') {
            $data['properties'] = array("firstname" => $GLOBALS['firstName'], "lastname" => $GLOBALS['lastName'], "phone" => $GLOBALS['phone'], "website" => $GLOBALS['domain'], "company" => $GLOBALS['name'], "linkedin_uid" => $GLOBALS['linkedin_uid'], "linkedin" => $GLOBALS['linkedin'], "email" => $GLOBALS['email'], "hubspot_owner_id" => $GLOBALS['owID'], "jobtitle" => $GLOBALS['occupation'], "contact_source" => "LinkedIn", "contact_assigned_by" => $GLOBALS['contact_assigned_by'], $GLOBALS['sitetitle_seq'] => $GLOBALS['seq_name']);
        } else {
            $data['properties'] = array("firstname" => $GLOBALS['firstName'], "lastname" => $GLOBALS['lastName'], "phone" => $GLOBALS['phone'], "website" => $GLOBALS['domain'], "company" => $GLOBALS['name'], "linkedin_uid" => $GLOBALS['linkedin_uid'], "linkedin" => $GLOBALS['linkedin'], "hubspot_owner_id" => $GLOBALS['owID'], "jobtitle" => $GLOBALS['occupation'], "contact_source" => "LinkedIn", "contact_assigned_by" => $GLOBALS['contact_assigned_by'], $GLOBALS['sitetitle_seq'] => $GLOBALS['seq_name']);
        }

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, 'https://api.hubapi.com/crm/v3/objects/contacts?hapikey=' . $GLOBALS['hsApiKey']);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_PROXY, "$proxyIp");
        curl_setopt($curl, CURLOPT_PROXYPORT, "$proxyPort");
        curl_setopt($curl, CURLOPT_PROXYUSERPWD, "$proxyUsername:$proxyPassword");
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
        $headers = array();
        $headers[] = 'Content-Type: application/json';
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        $contactresponse = curl_exec($curl);
        $err = curl_error($curl);
        $GLOBALS['httpcode'] = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);

        if ($err || (isset(json_decode($contactresponse)->status) && json_decode($contactresponse)->status == 'error')) {
            $message['errorMessage'] = "Something went wrong while Creating Contact";
        } else {
            $_POST['vid'] = json_decode($contactresponse)->id;
            global $message;
            $message['status'] = "Created";
            InsertMessage();
            $message['mess'] = '<a target="_blank" href="https://app.hubspot.com/sales/' . $GLOBALS['hsPortalId'] . '/contact/' . $_POST['vid'] . '/"> Contact &nbsp</a>  has been ' . $message['status'];
        }
    }

    function SetDisplayMessage() {
        global $message;

        $temp = array('message' => isset($message['mess']) ? $message['mess'] : '',
            'errorMessage' => isset($message['errorMessage']) ? $message['errorMessage'] : '',
            'vid' => isset($_POST['vid']) ? $_POST['vid'] : ''
        );
        echo json_encode($temp);
    }

    function CurlError($searchresponse) {
        if ((isset(json_decode($searchresponse)->status) && json_decode($searchresponse)->status == 'error')) {
            global $message;
            $message['errorMessage'] = json_decode($searchresponse)->message;
            return 1;
        } else {
            //echo "False";
            return 0;
        }
    }

    function GetMessage() {
        $proxyIp = $GLOBALS['proxyIp'];
        $proxyPort = $GLOBALS['proxyPort'];
        $proxyUsername = $GLOBALS['proxyUsername'];
        $proxyPassword = $GLOBALS['proxyPassword'];
        $Url = "https://api.hubapi.com/engagements/v1/engagements/associated/contact/" . $_POST["vid"] . "/paged?hapikey=" . $GLOBALS['hsApiKey'];
        $RequestType = "GET";
        $Header = array(
            "content-type: application/json"
        );
        $PostFields = '';

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $Url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLINFO_HEADER_OUT => true,
            CURLOPT_ENCODING => "",
            CURLOPT_HTTPPROXYTUNNEL => 1,
            CURLOPT_PROXY => "$proxyIp",
            CURLOPT_PROXYPORT => "$proxyPort",
            CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
            CURLOPT_CUSTOMREQUEST => $RequestType,
            CURLOPT_POSTFIELDS => $PostFields,
            CURLOPT_HTTPHEADER => $Header
        ));
        $MsgResponse = curl_exec($curl);
        $GLOBALS['httpcode'] = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        $err = curl_error($curl);
        curl_close($curl);


        $curlError = CurlError($MsgResponse);
        if ($curlError == 0) {
            $array = array();
            $tempArray = json_decode($MsgResponse)->results;
            for ($i = 0; $i < count($tempArray); $i++) {
                $array[$i] = $tempArray[$i]->engagement->uid;
            }
            return $array;
        }
    }

    function InsertMessage() {
        $chkUid = GetMessage();
//        print_r($chkUid);

        if ($GLOBALS['httpcode'] = 200 || $GLOBALS['httpcode'] = 201) {
            $Url = "https://api.hubapi.com/engagements/v1/engagements?hapikey=" . $GLOBALS['hsApiKey'];
            $RequestType = "POST";
            $Header = array(
                "content-type: application/json"
            );

            $msgs = json_decode($GLOBALS['msgs'], true);
            if ($msgs) {
                foreach ($msgs as $msg) {
                    if (!in_array($msg['id'] . ':' . $_POST["vid"], $chkUid)) {
                        $engagement = array('active' => 1,
                            'type' => 'NOTE',
                            'timeStamp' => $msg['timestamp'],
                            'uid' => (!empty($msg['id'])) ? $msg['id'] . ':' . $_POST['vid'] : ''
                        );
                        $associations = array('contactIds' => array($_POST["vid"]));
                        $metadata = array('body' => str_replace('/\n/g', '\x3cbr\x3e', $msg['text']));
                        $hubspotConversationStructure = array('engagement' => $engagement, 'associations' => $associations, 'metadata' => $metadata);
                        $PostFields = json_encode($hubspotConversationStructure);
                        $MsgResponse = CurlCommon($Url, $RequestType, $PostFields, $Header);
                        $curlError = CurlError($MsgResponse);
                        if ($curlError == 0) {
                            
                        }
                    }
                }
            }
        }
    }

    function CurlCommon($Url, $RequestType, $PostFields, $Header) {
        //echo 'in curl';
        //echo $Url;
        //echo '<pre>'; print_r($PostFields);    
        //echo '<pre>'; print_r($PostFields);    
        $proxyIp = $GLOBALS['proxyIp'];
        $proxyPort = $GLOBALS['proxyPort'];
        $proxyUsername = $GLOBALS['proxyUsername'];
        $proxyPassword = $GLOBALS['proxyPassword'];

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $Url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLINFO_HEADER_OUT => true,
            CURLOPT_ENCODING => "",
            CURLOPT_HTTPPROXYTUNNEL => 1,
            CURLOPT_PROXY => "$proxyIp",
            CURLOPT_PROXYPORT => "$proxyPort",
            CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
            CURLOPT_CUSTOMREQUEST => $RequestType,
            CURLOPT_POSTFIELDS => $PostFields,
            CURLOPT_HTTPHEADER => $Header
        ));
        $response = curl_exec($curl);
        $GLOBALS['httpcode'] = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        $err = curl_error($curl);
        if ($err)
            return $err;
        else
            return $response;

        curl_close($curl);
    }

    function AssociateContactToCompany($ConId, $CompID) {
        $proxyIp = $GLOBALS['proxyIp'];
        $proxyPort = $GLOBALS['proxyPort'];
        $proxyUsername = $GLOBALS['proxyUsername'];
        $proxyPassword = $GLOBALS['proxyPassword'];
        $data = array();
        $data['inputs'] = [array("from" => $ConId, "to" => $CompID, "type" => "contact_to_company")];
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, 'https://api.hubapi.com/crm/v3/associations/contact/company/batch/create?hapikey=' . $GLOBALS['hsApiKey']);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($curl, CURLOPT_PROXY, "$proxyIp");
        curl_setopt($curl, CURLOPT_PROXYPORT, "$proxyPort");
        curl_setopt($curl, CURLOPT_PROXYUSERPWD, "$proxyUsername:$proxyPassword");
        $headers = array();
        $headers[] = 'Content-Type: application/json';
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        $Response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err || (isset(json_decode($Response)->status) && json_decode($Response)->status == 'error')) {
            
        } else {
            global $message;

            $message['mess'] = '<p><a target="_blank" href="https://app.hubspot.com/sales/' . $GLOBALS['hsPortalId'] . '/contact/' . $_POST['vid'] . '">Contact</a> has been ' . $message['status'] . ' and associated with <a target=\"_blank\" href="https://app.hubspot.com/sales/' . $_POST['hsPortalId'] . '/company/' . $message['companyId'] . '">' . $message['companyStatus'] . '</a></p>';
        }
    }

    if ($domain != "") {
        CheckCompany($domain);
    }
    CheckContact();

    if (isset($_POST['vid']) && isset($message['companyId'])) {
        AssociateContactToCompany($_POST['vid'], $message['companyId']);
    }

    register_shutdown_function('SetDisplayMessage');
}