<?php

header("Access-Control-Allow-Origin:*");
header("Access-Control-Allow-Credentials:true");
header("Access-Control-Allow-Methods: OPTIONS, GET, POST");
header("Access-Control-Allow-Headers: Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");
$GLOBALS['httpcode'] = ''; // To set http response code from curlcommon fulction.
$message = array(); // To store the message of responses

function SetDomain() {
    if (isset($_POST['company']) && $_POST['company'] != '') {
        $domain = parse_url($_POST['company'][2]['value'], PHP_URL_HOST);

        if ($domain == "") {
            $domain = $_POST['company'][2]['value'];
        }
        return $domain;
    }
    return '';
}

function unicodeString($str, $encoding = null) {
    if (is_null($encoding))
        $encoding = ini_get('mbstring.internal_encoding');
    return preg_replace_callback('/u([0-9a-fA-F]{4})/u', function($match) use ($encoding) {
        return mb_convert_encoding(pack('H*', $match[1]), $encoding, 'UTF-16BE');
    }, $str);
}

$domain = SetDomain();

if ($domain != "") {
    CheckCompany($domain);
}
if (isset($_POST['vid'])) {
    UpdateContact();
} else {
    $CheckVar = isset($_POST['email']) ? $_POST['email'] : (
            isset($_POST['fullname']) ? trim(str_replace(".", "", $_POST['fullname'])) : '0'
            );
    CheckContact(unicodeString($CheckVar));
    //CreateNewContact();
}

function CurlCommon($Url, $RequestType, $PostFields, $Header) {
    //echo 'in curl';
    //echo $Url;
    //echo '<pre>'; print_r($PostFields);    
    //echo '<pre>'; print_r($PostFields);    
    $proxyIp = "brd.superproxy.io";
$proxyPort = "22225";
$proxyUsername = "brd-customer-hl_5b864891-zone-hubspotapi";
$proxyPassword = "qjuurxof7nyi";

    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => $Url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLINFO_HEADER_OUT => true,
        CURLOPT_ENCODING => "",
        CURLOPT_HTTPPROXYTUNNEL => 1,
        CURLOPT_PROXY => "$proxyIp",
        CURLOPT_PROXYPORT => "$proxyPort",
        CURLOPT_PROXYUSERPWD => "$proxyUsername:$proxyPassword",
        CURLOPT_CUSTOMREQUEST => $RequestType,
        CURLOPT_POSTFIELDS => $PostFields,
        CURLOPT_HTTPHEADER => $Header
    ));
    $response = curl_exec($curl);
    $GLOBALS['httpcode'] = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    $err = curl_error($curl);
    if ($err)
        return $err;
    else
        return $response;

    curl_close($curl);
}

function CurlError($searchresponse) {
    if ((isset(json_decode($searchresponse)->status) && json_decode($searchresponse)->status == 'error')) {
        global $message;
        $message['errorMessage'] = json_decode($searchresponse)->message;
        return 1;
    } else {
        //echo "False";
        return 0;
    }
}

/* To check Comapany already exsist or not */

function CheckCompany($domain) {
    //echo 'in chk company';
    $Url = "https://api.hubapi.com/companies/v2/domains/" . $domain . "/companies?hapikey=" . $_POST['hsApiKey'];
    $RequestType = "POST";
    $PostFields = "{\r\n  \"limit\": 1,\r\n  \"requestOptions\": {\r\n    \"properties\": [\r\n      \"domain\",\r\n      \"createdate\",\r\n      \"name\",\r\n      \"hs_lastmodifieddate\"\r\n    ]\r\n  },\r\n  \"offset\": {\r\n    \"isPrimary\": true,\r\n    \"companyId\": 0\r\n  }\r\n}\r\n";
    $Header = array(
        "Content-Type: application/json"
    );
    //$logfile = file_put_contents('Manishadduser2.php',"Check company " .$PostFields. PHP_EOL, FILE_APPEND | LOCK_EX);
    $searchresponse = CurlCommon($Url, $RequestType, $PostFields, $Header);
    $curlError = CurlError($searchresponse);
    if ($curlError == 0) {
        $compId = json_decode($searchresponse)->offset->companyId;
        if ($compId == 0) {
            CreateNewComapny($searchresponse);
        } else {
            UpdateCompany($compId);
        }
    }
}

/* To Create new company */

function CreateNewComapny($searchresponse) {
    //echo 'in new company';
    $domain = SetDomain();
    $compnyArrray = [];
    foreach ($_POST['company'] as $company) {
        if ($company['name'] == 'domain')
            $company['value'] = $domain;
        $compnyArrray['properties'][] = ['name' => $company['name'], 'value' => $company['value']];
    }

    $str = json_encode($compnyArrray);

    //$logfile = file_put_contents('Manishadduser2.php',"Create New Comapny " .$str. PHP_EOL, FILE_APPEND | LOCK_EX);
    $Url = "https://api.hubapi.com/companies/v2/companies?hapikey=" . $_POST['hsApiKey'];
    $RequestType = "POST";
    $PostFields = $str;
    $Header = array(
        "content-type: application/json"
    );
    $createresponse = CurlCommon($Url, $RequestType, $PostFields, $Header);
    $curlError = CurlError($createresponse);
    if ($curlError == 0) {
        global $message;
        $message['companyId'] = json_decode($createresponse)->companyId;
        $message['companyStatus'] = "New Company";
    } else if ($curlError == 1) {
        $message['errorMessage'] = "Something went wrong while Creating Company";
    }
}

function UpdateCompany($compId) {
    //echo 'in company'; 
    $domain = SetDomain();
    $compnyArrray = [];
    foreach ($_POST['company'] as $company) {
        if ($company['name'] == 'domain')
            $company['value'] = $domain;
        $compnyArrray['properties'][] = ['name' => $company['name'], 'value' => $company['value']];
    }

    //echo '<prE>'; print_r($compnyArrray);

    $str = json_encode($compnyArrray);
    $Url = "https://api.hubapi.com/companies/v2/companies/" . $compId . "?hapikey=" . $_POST['hsApiKey'];
    $RequestType = "PUT";
    $PostFields = $str;
    $Header = array(
        "content-type: application/json"
    );
    $createresponse = CurlCommon($Url, $RequestType, $PostFields, $Header);
    $curlError = CurlError($createresponse);
    if ($curlError == 0) {
        global $message;
        $message['companyId'] = json_decode($createresponse)->companyId;
        $message['companyStatus'] = "Existing Company";
    } else if ($curlError == 1) {
        $message['errorMessage'] = "Something went wrong while Updating Company";
    }
}

function UpdateContact() {
    //echo 'in update'; 
    $str = ContactDetails();
    $str = unicodeString($str);
    //echo '<pre>'; print_r($str); 
    //$logfile = file_put_contents('Manishadduser2.php',"Update Contact " .$str. PHP_EOL, FILE_APPEND | LOCK_EX);

    $Url = "https://api.hubapi.com/contacts/v1/contact/vid/" . $_POST['vid'] . "/profile?hapikey=" . $_POST['hsApiKey'];
    $RequestType = "POST";
    $PostFields = $str;
    $Header = array(
        "content-type: application/json"
    );
    $updateresponse = CurlCommon($Url, $RequestType, $PostFields, $Header);
    $curlError = CurlError($updateresponse);
    if ($curlError == 0) {
        global $message;
        $message['status'] = "Updated";
        InsertMessage();
        $message['mess'] = '<a target="_blank" href="https://app.hubspot.com/sales/' . $_POST['hsPortalId'] . '/contact/' . $_POST['vid'] . '/">Contact</a>&nbsp has been ' . $message['status'];
    } else if ($curlError == 1) {
        $message['errorMessage'] = "Something went wrong while Updating Contact";
    }
}

function CreateNewContact() {
    $str = ContactDetails();
    $str = unicodeString($str);
    //echo '<pre>'; print_r($str);

    $Url = "https://api.hubapi.com/contacts/v1/contact?hapikey=" . $_POST['hsApiKey'];
    $RequestType = "POST";
    $PostFields = $str;
    $Header = array(
        "content-type: application/json"
    );
    //$logfile = file_put_contents('Manishadduser2.php',"Create New Cotact " .$str. PHP_EOL, FILE_APPEND | LOCK_EX);
    $contactresponse = CurlCommon($Url, $RequestType, $PostFields, $Header);
    $curlError = CurlError($contactresponse);
    if ($curlError == 0) {
        $_POST['vid'] = json_decode($contactresponse)->vid;
        global $message;
        $message['status'] = "Created";
        InsertMessage();
        $message['mess'] = '<a target="_blank" href="https://app.hubspot.com/sales/' . $_POST['hsPortalId'] . '/contact/' . $_POST['vid'] . '/"> Contact &nbsp</a>  has been ' . $message['status'];
    } else if ($curlError == 1) {
        $message['errorMessage'] = "Something went wrong while Creating Contact";
    }
}

function ContactDetails() {
    $contactArrray = [];
    $domain = SetDomain();
    foreach ($_POST['contact'] as $contact) {
        //echo '<pre>'; print_r($contact);
        if (isset($contact['value'])) {
            //echo $contact['value'];
            if ($contact['property'] != 'website') {
                $propArray = array('firstname', 'lastname');
                if (in_array($contact['property'], $propArray)) {
                    $contactArrray['properties'][] = ['property' => $contact['property'], 'value' => trim(str_replace(".", "", $contact['value']))];
                } else {
                    $contactArrray['properties'][] = ['property' => $contact['property'], 'value' => $contact['value']];
                }
            }
        }
    }
    if (isset($_POST['company']) && $_POST['company'] != '') {
        foreach ($_POST['company'] as $company) {
            if ($company['name'] == 'domain') {
                $company['value'] = $domain;
                $company['name'] = 'website';
                $contactArrray['properties'][] = ['property' => $company['name'], 'value' => $company['value']];
            }
            if ($company['name'] == 'name') {
                $company['name'] = 'company';
                continue;
            }
            if ($company['name'] == 'linkedin_company_page')
                continue;
            //$contactArrray['properties'][] = ['property'=> $company['name'],'value'=>$company['value']];
        }
    }

// echo $contactArrray; 

    $str = json_encode($contactArrray);
    return $str;
}

function GetMessage() {
    $Url = "https://api.hubapi.com/engagements/v1/engagements/associated/contact/" . $_POST["vid"] . "/paged?hapikey=" . $_POST['hsApiKey'];
    $RequestType = "GET";
    $Header = array(
        "content-type: application/json"
    );
    $PostFields = '';
    $MsgResponse = CurlCommon($Url, $RequestType, $PostFields, $Header);
    $curlError = CurlError($MsgResponse);
    if ($curlError == 0) {
        $array = array();
        $tempArray = json_decode($MsgResponse)->results;
        for ($i = 0; $i < count($tempArray); $i++) {
            $array[$i] = $tempArray[$i]->engagement->uid;
        }
        return $array;
    }
}

function InsertMessage() {


    $chkUid = GetMessage();

    if ($GLOBALS['httpcode'] = 204) {
        $Url = "https://api.hubapi.com/engagements/v1/engagements?hapikey=" . $_POST['hsApiKey'];
        $RequestType = "POST";
        $Header = array(
            "content-type: application/json"
        );

        $msgs = json_decode($_POST['msgs'], true);
        if ($msgs) {
            foreach ($msgs as $msg) {
                if (!in_array($msg['id'] . ':' . $_POST["vid"], $chkUid)) {
                    $engagement = array('active' => 1,
                        'type' => 'NOTE',
                        'timeStamp' => $msg['timestamp'],
                        'uid' => (!empty($msg['id'])) ? $msg['id'] . ':' . $_POST['vid'] : ''
                    );
                    $associations = array('contactIds' => array($_POST["vid"]));
                    $metadata = array('body' => str_replace('/\n/g', '\x3cbr\x3e', $msg['text']));
                    $hubspotConversationStructure = array('engagement' => $engagement, 'associations' => $associations, 'metadata' => $metadata);
                    $PostFields = json_encode($hubspotConversationStructure);
                    $MsgResponse = CurlCommon($Url, $RequestType, $PostFields, $Header);
                    $curlError = CurlError($MsgResponse);
                    if ($curlError == 0) {
                        
                    }
                }
            }
        }




//        exit;
//        foreach ($msgs as $msg) {
//            if (!in_array($msg[2] . ':' . $_POST["vid"], $chkUid)) {
//                $msg[1] = str_replace('"', '', json_encode($msg[1]));
//                $msg_string = '{"engagement":{"active":true,"type":"NOTE","timestamp":' . $msg[0] . ',"uid":"' . $msg[2] . ':' . $_POST["vid"] . '"},"associations":{"contactIds":[' . $_POST["vid"] . ']},"metadata":{"body":"' . $msg[3] . ' said:<br>' . $msg[1] . '"}}';
//                $PostFields = $msg_string;
//                //$logfile = file_put_contents('Manishadduser2.php',"Messages" .$msg_string. PHP_EOL, FILE_APPEND | LOCK_EX);
//                $MsgResponse = CurlCommon($Url, $RequestType, $PostFields, $Header);
//                $curlError = CurlError($MsgResponse);
//                if ($curlError == 0) {
//                    
//                }
//            }
//        }
    }
}

function SetDisplayMessage() {
    global $message;

    $temp = array('message' => isset($message['mess']) ? $message['mess'] : '',
        'errorMessage' => isset($message['errorMessage']) ? $message['errorMessage'] : '',
        'vid' => isset($_POST['vid']) ? $_POST['vid'] : ''
    );
    echo json_encode($temp);
}

if (isset($_POST['vid']) && isset($message['companyId'])) {
    AssociateContactToCompany($_POST['vid'], $message['companyId']);
}

function AssociateContactToCompany($ConId, $CompID) {
    $Url = "https://api.hubapi.com/companies/v2/companies/" . $CompID . "/contacts/" . $ConId . "?hapikey=" . $_POST['hsApiKey'];
    $RequestType = "PUT";
    $Header = array(
        "content-type: application/json"
    );
    $PostFields = '';
    $Response = CurlCommon($Url, $RequestType, $PostFields, $Header);
    $curlError = CurlError($Response);
    if ($curlError == 0) {
        global $message;

        $message['mess'] = '<p><a target="_blank" href="https://app.hubspot.com/sales/' . $_POST['hsPortalId'] . '/contact/' . $_POST['vid'] . '">Contact</a> has been ' . $message['status'] . ' and associated with <a target=\"_blank\" href="https://app.hubspot.com/sales/' . $_POST['hsPortalId'] . '/company/' . $message['companyId'] . '">' . $message['companyStatus'] . '</a></p>';
    }
}

function CheckContact($a) {
//    echo 'in';
//    echo $a;

    $Url = "https://api.hubapi.com/contacts/v1/search/query?hapikey=" . $_POST['hsApiKey'] . "&q=" . $a;
    $RequestType = "GET";
    $PostFields = '';
    $Header = array();
    $contactresponse = CurlCommon($Url, $RequestType, $PostFields, $Header);
    $curlError = CurlError($contactresponse);

    if ($curlError == 0) {
        if (json_decode($contactresponse)->offset > 0) {
            $_POST['vid'] = json_decode($contactresponse)->contacts[0]->vid;
            UpdateContact();
        } else {
            CreateNewContact();
        }
    } else if ($curlError == 1) {
        $message['errorMessage'] = "Something went wrong while Checking Contact";
    }
}

register_shutdown_function('SetDisplayMessage');
