<?php
/*
 * Pipedrive
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace Pipedrive\Tests;

use Pipedrive\APIException;
use Pipedrive\Exceptions;
use Pipedrive\APIHelper;
use Pipedrive\Models;

class UsersControllerTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var \Pipedrive\Controllers\UsersController Controller instance
     */
    protected static $controller;

    /**
     * @var HttpCallBackCatcher Callback
     */
    protected $httpResponse;

    /**
     * Setup test class
     */
    public static function setUpBeforeClass()
    {
        $client = new \Pipedrive\Client();
        self::$controller = $client->getUsers();
    }

    /**
     * Setup test
     */
    protected function setUp()
    {
        $this->httpResponse = new HttpCallBackCatcher();
    }

    /**
     * Returns data about all users within the company
     */
    public function testTestGetAllUsers()
    {

        // Set callback and perform API call
        $result = null;
        self::$controller->setHttpCallBack($this->httpResponse);
        try {
            $result = self::$controller->getAllUsers();
        } catch (APIException $e) {
        }

        // Test response code
        $this->assertEquals(
            200,
            $this->httpResponse->getResponse()->getStatusCode(),
            "Status is not 200"
        );

        // Test headers
        $headers = [];
        $headers['Content-Type'] = 'application/json' ;

        $this->assertTrue(
            TestHelper::areHeadersProperSubsetOf($headers, $this->httpResponse->getResponse()->getHeaders(), true),
            "Headers do not match"
        );

        // Test whether the captured response is as we expected
        $this->assertNotNull($result, "Result does not exist");

        $this->assertTrue(
            TestHelper::isJsonObjectProperSubsetOf(
                "{\"success\":true,\"data\":[{\"id\":1,\"name\":\"John Doe\",\"default_currency\":\"EUR\",\"locale\":" .
                "\"et_EE\",\"lang\":1,\"email\":\"john@pipedrive.com\",\"phone\":\"0000-0001\",\"activated\":true,\"l" .
                "ast_login\":\"2019-11-21 08:45:56\",\"created\":\"2018-11-13 09:16:26\",\"modified\":\"2019-11-21 08" .
                ":45:56\",\"signup_flow_variation\":\"google\",\"has_created_company\":true,\"is_admin\":1,\"active_f" .
                "lag\":true,\"timezone_name\":\"Europe/Berlin\",\"timezone_offset\":\"+03:00\",\"role_id\":1,\"icon_u" .
                "rl\":\"https://upload.wikimedia.org/wikipedia/en/thumb/e/e0/WPVG_icon_2016.svg/1024px-WPVG_icon_2016" .
                ".svg.png\",\"is_you\":true},{\"id\":2,\"name\":\"Jane Doe\",\"default_currency\":\"EUR\",\"locale\":" .
                "\"et_EE\",\"lang\":1,\"email\":\"jane@pipedrive.com\",\"phone\":\"0000-0002\",\"activated\":true,\"l" .
                "ast_login\":\"2019-09-11 11:43:54\",\"created\":\"2019-01-22 10:43:47\",\"modified\":\"2019-11-21 09" .
                ":49:50\",\"signup_flow_variation\":null,\"has_created_company\":false,\"is_admin\":0,\"active_flag\"" .
                ":true,\"timezone_name\":\"Europe/Berlin\",\"timezone_offset\":\"+03:00\",\"role_id\":1,\"icon_url\":" .
                "null,\"is_you\":false}]}",
                $this->httpResponse->getResponse()->getRawBody(),
                false,
                true,
                false
            ),
            "Response body does not match in keys"
        );
    }

    /**
     * Returns data about an authorized user within the company with bound company data: company ID, company name, and domain. Note that the 'locale' property means 'Date and number format' in the Pipedrive settings, not the chosen language.
     */
    public function testTestGetCurrentUserData()
    {

        // Set callback and perform API call
        $result = null;
        self::$controller->setHttpCallBack($this->httpResponse);
        try {
            $result = self::$controller->getCurrentUserData();
        } catch (APIException $e) {
        }

        // Test response code
        $this->assertEquals(
            200,
            $this->httpResponse->getResponse()->getStatusCode(),
            "Status is not 200"
        );

        // Test headers
        $headers = [];
        $headers['Content-Type'] = 'application/json' ;

        $this->assertTrue(
            TestHelper::areHeadersProperSubsetOf($headers, $this->httpResponse->getResponse()->getHeaders(), true),
            "Headers do not match"
        );

        // Test whether the captured response is as we expected
        $this->assertNotNull($result, "Result does not exist");

        $this->assertTrue(
            TestHelper::isJsonObjectProperSubsetOf(
                "{\"success\":true,\"data\":{\"id\":1,\"name\":\"Me\",\"default_currency\":\"EUR\",\"locale\":\"et_EE" .
                "\",\"lang\":1,\"email\":\"me@pipedrive.com\",\"phone\":\"0000-0000\",\"activated\":true,\"last_login" .
                "\":\"2019-11-21 08:45:56\",\"created\":\"2018-11-13 09:16:26\",\"modified\":\"2019-11-21 08:45:56\"," .
                "\"signup_flow_variation\":\"google\",\"has_created_company\":true,\"is_admin\":1,\"active_flag\":tru" .
                "e,\"timezone_name\":\"Europe/Berlin\",\"timezone_offset\":\"+03:00\",\"role_id\":1,\"icon_url\":\"ht" .
                "tps://upload.wikimedia.org/wikipedia/en/thumb/e/e0/WPVG_icon_2016.svg/1024px-WPVG_icon_2016.svg.png" .
                "\",\"is_you\":true,\"company_id\":54235233,\"company_name\":\"Pipedrive\",\"company_domain\":\"piped" .
                "rive-12g53f\",\"language\":{\"language_code\":\"en\",\"country_code\":\"US\"}}}",
                $this->httpResponse->getResponse()->getRawBody(),
                false,
                true,
                false
            ),
            "Response body does not match in keys"
        );
    }
}
