<?php
/*
 * Pipedrive
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace Pipedrive;

use \Exception;
use Pipedrive\Controllers\OAuthAuthorizationController;

/**
 * Utility class for OAuth 2 authorization and token management
 */
class OAuthManager
{
    /**
     * @var OAuthManager The reference to singleton instance of this class
     */
    private static $instance;

    /**
     * Singleton instance of OAuth 2 API controller
     * @var OAuthAuthorizationController
     */
    private $oAuthApi;

    /**
     * Returns the *Singleton* instance of this class.
     * @return OAuthManager The *Singleton* instance.
     */
    public static function getInstance()
    {
        if (null === static::$instance) {
            static::$instance = new static();
        }

        return static::$instance;
    }

    /**
     * Constructor
     */
    private function __construct()
    {
        $this->oAuthApi = OAuthAuthorizationController::getInstance();
    }

    /**
     * Build an authorization URL for taking the user's consent to access data
     * @param  array|string|null $scope            List of scopes needed
     * @param  string|null       $state            An opaque state string
     * @param  array|null        $additionalParams Additional parameters to add the the authorization URL
     * @return string
     */
    public function buildAuthorizationUrl($scope = null, $state = null, $additionalParams = null)
    {
        //the base uri for api requests
        $queryBuilder = Configuration::getBaseUri(Servers::OAUTH);

        //prepare query string for API call
        $queryBuilder = $queryBuilder . '/oauth/authorize';

        //build query params
        $queryParams = array (
            'response_type' => 'code',
            'client_id'     => Configuration::$oAuthClientId,
            'redirect_uri'  => Configuration::$oAuthRedirectUri,
            'scope'         => is_array($scope) ? implode(' ', $scope) : $scope,
            'state'         => $state
        );

        if ($additionalParams != null && is_array($additionalParams)) {
            $queryParams = array_merge($additionalParams, $queryParams);
        }

        //process optional query parameters
        APIHelper::appendUrlWithQueryParameters($queryBuilder, $queryParams);

        //validate and preprocess url
        return APIHelper::cleanUrl($queryBuilder);
    }

    /**
     * Authorize the client with the OAuth provider
     * @param  string     $authorizationCode Authorization code returned by the OAuth provider
     * @param  array|null $additionalParams  Additional parameters to send during authorization
     * @return \Pipedrive\Models\OAuthToken
     */
    public function authorize($authorizationCode, $additionalParams = null)
    {
        //send request for access token
        $oAuthToken = $this->oAuthApi->createRequestToken(
            array (
                'authorization' => $this->buildBasicHeader(),
                'code' => $authorizationCode,
                'redirectUri' => Configuration::$oAuthRedirectUri,
            ),
            $additionalParams
        );

        //update configuration
        static::updateOAuthToken($oAuthToken);

        return $oAuthToken;
    }

    /**
     * Refresh the OAuth token
     * @param  array|string|null $scope            List of scopes needed. Should only be passed if scopes need to be
     *                                             changed.
     * @param  array|null        $additionalParams Additional parameters to send during token refresh
     * @return \Pipedrive\Models\OAuthToken
     */
    public function refreshToken($scope = null, $additionalParams = null)
    {
        //send request for token refresh
        $oAuthToken = $this->oAuthApi->createRefreshToken(
            array (
                'authorization' => $this->buildBasicHeader(),
                'refreshToken' => Configuration::$oAuthToken->refreshToken,
                'scope' => is_array($scope) ? implode(' ', $scope) : $scope,
            ),
            $additionalParams
        );

        //update configuration
        static::updateOAuthToken($oAuthToken);

        return $oAuthToken;
    }

    /**
     * Has the OAuth token expired?
     * @return boolean
     */
    public function isTokenExpired()
    {
        return isset(Configuration::$oAuthToken->expiry) && Configuration::$oAuthToken->expiry < time();
    }

    /**
     * Check if client is authorized, else attempt to get token
     */
    public function checkAuthorization()
    {
        //authorization is needed before making API calls
        if (Configuration::$oAuthToken->accessToken == null && Configuration::$apiToken == null ) {
            throw new Exception('Client is not authorized. An OAuth token or an API token is needed to make API calls.');
        }

        if (Configuration::$apiToken != null ) {
            return;
        }

        //refresh token if expired
        if ($this->isTokenExpired()) {
            $this->refreshToken();
        }
    }

    /**
     * Update OAuth token in configuration
     * @param  \Pipedrive\Models\OAuthToken $oAuthToken OAuth token
     */
    private static function updateOAuthToken($oAuthToken)
    {
        //add expiry
        if ($oAuthToken->expiresIn != null && $oAuthToken->expiresIn != 0) {
            $oAuthToken->expiry = time() + $oAuthToken->expiresIn;
        }

        //update config and call callback
        Configuration::$oAuthToken = $oAuthToken;

        if (is_callable(Configuration::$oAuthTokenUpdateCallback)) {
            call_user_func(Configuration::$oAuthTokenUpdateCallback, $oAuthToken);
        }
    }

    /**
     * Build authorization header value for basic auth
     * @param  string $username Username
     * @param  string $password Password
     * @return string
     */
    private static function buildBasicHeader()
    {
        return 'Basic ' . base64_encode(
            Configuration::$oAuthClientId . ':' . Configuration::$oAuthClientSecret
        );
    }
}
