<?php
/*
 * Pipedrive
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace Pipedrive\Models;

use JsonSerializable;
use Pipedrive\Utils\DateTimeHelper;

/**
 * @todo Write general description for this model
 */
class MailMessageData implements JsonSerializable
{
    /**
     * ID of the mail message.
     * @var integer|null $id public property
     */
    public $id;

    /**
     * The array of mail message sender (object)
     * @var \Pipedrive\Models\MailParticipant[]|null $from public property
     */
    public $from;

    /**
     * The array of mail message receiver (object)
     * @var \Pipedrive\Models\MailParticipant[]|null $to public property
     */
    public $to;

    /**
     * The array of mail message copies (object)
     * @var \Pipedrive\Models\MailParticipant[]|null $cc public property
     */
    public $cc;

    /**
     * The array of mail message blind copies (object)
     * @var \Pipedrive\Models\MailParticipant[]|null $bcc public property
     */
    public $bcc;

    /**
     * The mail message body URL
     * @maps body_url
     * @var string|null $bodyUrl public property
     */
    public $bodyUrl;

    /**
     * The connection account ID
     * @maps account_id
     * @var string|null $accountId public property
     */
    public $accountId;

    /**
     * ID of the user whom mail message will be assigned to
     * @maps user_id
     * @var integer|null $userId public property
     */
    public $userId;

    /**
     * ID of the mail message thread
     * @maps mail_thread_id
     * @var integer|null $mailThreadId public property
     */
    public $mailThreadId;

    /**
     * The subject of mail message
     * @var string|null $subject public property
     */
    public $subject;

    /**
     * The snippet of mail message. Snippet length is up to 225 characters.
     * @var string|null $snippet public property
     */
    public $snippet;

    /**
     * The status of tracking mail message. Value is null if tracking is not enabled.
     * @maps mail_tracking_status
     * @var string|null $mailTrackingStatus public property
     */
    public $mailTrackingStatus;

    /**
     * Whether the link tracking in mail message body is enabled.
     * @maps mail_link_tracking_enabled_flag
     * @var int|null $mailLinkTrackingEnabledFlag public property
     */
    public $mailLinkTrackingEnabledFlag;

    /**
     * Whether the mail message is read or not by the user
     * @maps read_flag
     * @var int|null $readFlag public property
     */
    public $readFlag;

    /**
     * If the mail message has a draft status then the value is the mail message object as JSON formatted
     * string, otherwise null.
     * @var string|null $draft public property
     */
    public $draft;

    /**
     * Whether the mail message is a draft or not
     * @maps draft_flag
     * @var int|null $draftFlag public property
     */
    public $draftFlag;

    /**
     * Whether the mail message is synced with the provider or not
     * @maps synced_flag
     * @var int|null $syncedFlag public property
     */
    public $syncedFlag;

    /**
     * Whether the mail message is deleted or not
     * @maps deleted_flag
     * @var int|null $deletedFlag public property
     */
    public $deletedFlag;

    /**
     * Whether the mail message has a body or not
     * @maps has_body_flag
     * @var int|null $hasBodyFlag public property
     */
    public $hasBodyFlag;

    /**
     * Whether the mail message has been sent or not
     * @maps sent_flag
     * @var int|null $sentFlag public property
     */
    public $sentFlag;

    /**
     * Whether the mail message has been sent from Pipedrive app or not
     * @maps sent_from_pipedrive_flag
     * @var int|null $sentFromPipedriveFlag public property
     */
    public $sentFromPipedriveFlag;

    /**
     * Whether the mail message has been created by Smart Email BCC feature or not
     * @maps smart_bcc_flag
     * @var int|null $smartBccFlag public property
     */
    public $smartBccFlag;

    /**
     * Creation or receival time of the mail message
     * @maps message_time
     * @factory \Pipedrive\Utils\DateTimeHelper::fromSimpleDate
     * @var \DateTime|null $messageTime public property
     */
    public $messageTime;

    /**
     * The insertion into the database time of the mail message
     * @maps add_time
     * @factory \Pipedrive\Utils\DateTimeHelper::fromSimpleDate
     * @var \DateTime|null $addTime public property
     */
    public $addTime;

    /**
     * The updating time in the database of the mail message
     * @maps update_time
     * @factory \Pipedrive\Utils\DateTimeHelper::fromSimpleDate
     * @var \DateTime|null $updateTime public property
     */
    public $updateTime;

    /**
     * Whether the mail message has an attachment or not
     * @maps has_attachments_flag
     * @var int|null $hasAttachmentsFlag public property
     */
    public $hasAttachmentsFlag;

    /**
     * Whether the mail message has an inline attachment or not
     * @maps has_inline_attachments_flag
     * @var int|null $hasInlineAttachmentsFlag public property
     */
    public $hasInlineAttachmentsFlag;

    /**
     * Whether the mail message has an attachment (which is not inline) or not
     * @maps has_real_attachments_flag
     * @var int|null $hasRealAttachmentsFlag public property
     */
    public $hasRealAttachmentsFlag;

    /**
     * We strongly advise you to avoid the use of this property. We will soon deprecate this property.
     * @maps write_flag
     * @var bool|null $writeFlag public property
     */
    public $writeFlag;

    /**
     * Constructor to set initial or default values of member properties
     * @param integer   $id                          Initialization value for $this->id
     * @param array     $from                        Initialization value for $this->from
     * @param array     $to                          Initialization value for $this->to
     * @param array     $cc                          Initialization value for $this->cc
     * @param array     $bcc                         Initialization value for $this->bcc
     * @param string    $bodyUrl                     Initialization value for $this->bodyUrl
     * @param string    $accountId                   Initialization value for $this->accountId
     * @param integer   $userId                      Initialization value for $this->userId
     * @param integer   $mailThreadId                Initialization value for $this->mailThreadId
     * @param string    $subject                     Initialization value for $this->subject
     * @param string    $snippet                     Initialization value for $this->snippet
     * @param string    $mailTrackingStatus          Initialization value for $this->mailTrackingStatus
     * @param int       $mailLinkTrackingEnabledFlag Initialization value for $this->mailLinkTrackingEnabledFlag
     * @param int       $readFlag                    Initialization value for $this->readFlag
     * @param string    $draft                       Initialization value for $this->draft
     * @param int       $draftFlag                   Initialization value for $this->draftFlag
     * @param int       $syncedFlag                  Initialization value for $this->syncedFlag
     * @param int       $deletedFlag                 Initialization value for $this->deletedFlag
     * @param int       $hasBodyFlag                 Initialization value for $this->hasBodyFlag
     * @param int       $sentFlag                    Initialization value for $this->sentFlag
     * @param int       $sentFromPipedriveFlag       Initialization value for $this->sentFromPipedriveFlag
     * @param int       $smartBccFlag                Initialization value for $this->smartBccFlag
     * @param \DateTime $messageTime                 Initialization value for $this->messageTime
     * @param \DateTime $addTime                     Initialization value for $this->addTime
     * @param \DateTime $updateTime                  Initialization value for $this->updateTime
     * @param int       $hasAttachmentsFlag          Initialization value for $this->hasAttachmentsFlag
     * @param int       $hasInlineAttachmentsFlag    Initialization value for $this->hasInlineAttachmentsFlag
     * @param int       $hasRealAttachmentsFlag      Initialization value for $this->hasRealAttachmentsFlag
     * @param bool      $writeFlag                   Initialization value for $this->writeFlag
     */
    public function __construct()
    {
        if (29 == func_num_args()) {
            $this->id                          = func_get_arg(0);
            $this->from                        = func_get_arg(1);
            $this->to                          = func_get_arg(2);
            $this->cc                          = func_get_arg(3);
            $this->bcc                         = func_get_arg(4);
            $this->bodyUrl                     = func_get_arg(5);
            $this->accountId                   = func_get_arg(6);
            $this->userId                      = func_get_arg(7);
            $this->mailThreadId                = func_get_arg(8);
            $this->subject                     = func_get_arg(9);
            $this->snippet                     = func_get_arg(10);
            $this->mailTrackingStatus          = func_get_arg(11);
            $this->mailLinkTrackingEnabledFlag = func_get_arg(12);
            $this->readFlag                    = func_get_arg(13);
            $this->draft                       = func_get_arg(14);
            $this->draftFlag                   = func_get_arg(15);
            $this->syncedFlag                  = func_get_arg(16);
            $this->deletedFlag                 = func_get_arg(17);
            $this->hasBodyFlag                 = func_get_arg(18);
            $this->sentFlag                    = func_get_arg(19);
            $this->sentFromPipedriveFlag       = func_get_arg(20);
            $this->smartBccFlag                = func_get_arg(21);
            $this->messageTime                 = func_get_arg(22);
            $this->addTime                     = func_get_arg(23);
            $this->updateTime                  = func_get_arg(24);
            $this->hasAttachmentsFlag          = func_get_arg(25);
            $this->hasInlineAttachmentsFlag    = func_get_arg(26);
            $this->hasRealAttachmentsFlag      = func_get_arg(27);
            $this->writeFlag                   = func_get_arg(28);
        }
    }


    /**
     * Encode this object to JSON
     */
    public function jsonSerialize()
    {
        $json = array();
        $json['id']                              = $this->id;
        $json['from']                            = $this->from;
        $json['to']                              = $this->to;
        $json['cc']                              = $this->cc;
        $json['bcc']                             = $this->bcc;
        $json['body_url']                        = $this->bodyUrl;
        $json['account_id']                      = $this->accountId;
        $json['user_id']                         = $this->userId;
        $json['mail_thread_id']                  = $this->mailThreadId;
        $json['subject']                         = $this->subject;
        $json['snippet']                         = $this->snippet;
        $json['mail_tracking_status']            = $this->mailTrackingStatus;
        $json['mail_link_tracking_enabled_flag'] = $this->mailLinkTrackingEnabledFlag;
        $json['read_flag']                       = $this->readFlag;
        $json['draft']                           = $this->draft;
        $json['draft_flag']                      = $this->draftFlag;
        $json['synced_flag']                     = $this->syncedFlag;
        $json['deleted_flag']                    = $this->deletedFlag;
        $json['has_body_flag']                   = $this->hasBodyFlag;
        $json['sent_flag']                       = $this->sentFlag;
        $json['sent_from_pipedrive_flag']        = $this->sentFromPipedriveFlag;
        $json['smart_bcc_flag']                  = $this->smartBccFlag;
        $json['message_time']                    = isset($this->messageTime) ?
            DateTimeHelper::toSimpleDate($this->messageTime) : null;
        $json['add_time']                        = isset($this->addTime) ?
            DateTimeHelper::toSimpleDate($this->addTime) : null;
        $json['update_time']                     = isset($this->updateTime) ?
            DateTimeHelper::toSimpleDate($this->updateTime) : null;
        $json['has_attachments_flag']            = $this->hasAttachmentsFlag;
        $json['has_inline_attachments_flag']     = $this->hasInlineAttachmentsFlag;
        $json['has_real_attachments_flag']       = $this->hasRealAttachmentsFlag;
        $json['write_flag']                      = $this->writeFlag;

        return $json;
    }
}
