<?php
/*
 * Pipedrive
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace Pipedrive\Models;

use JsonSerializable;

/**
 *The updated Product object attached to the Deal
 */
class Data26 implements JsonSerializable
{
    /**
     * Price at which this product will be added to the deal
     * @maps item_price
     * @var double|null $itemPrice public property
     */
    public $itemPrice;

    /**
     * Quantity – e.g. how many items of this product will be added to the deal
     * @var integer|null $quantity public property
     */
    public $quantity;

    /**
     * Discount %. If omitted, will be set to 0
     * @maps discount_percentage
     * @var double|null $discountPercentage public property
     */
    public $discountPercentage;

    /**
     * Duration of the product (when product durations are not enabled for the company or if omitted,
     * defaults to 1)
     * @var double|null $duration public property
     */
    public $duration;

    /**
     * ID of the product variation to use. When omitted, no variation will be used.
     * @maps product_variation_id
     * @var integer|null $productVariationId public property
     */
    public $productVariationId;

    /**
     * Any textual comment associated with this product-deal attachment. Visible and editable in the
     * application UI.
     * @var string|null $comments public property
     */
    public $comments;

    /**
     * Whether the product is enabled on the deal or not. This makes it possible to add products to a deal
     * with specific price and discount criteria - but keep them disabled, which refrains them from being
     * included in deal price calculation. When omitted, the product will be marked as enabled by default.
     * @maps enabled_flag
     * @var int|null $enabledFlag public property
     */
    public $enabledFlag;

    /**
     * The ID of the deal-product (the ID of the Product attached to the Deal)
     * @var integer|null $id public property
     */
    public $id;

    /**
     * The ID of the Company
     * @maps company_id
     * @var integer|null $companyId public property
     */
    public $companyId;

    /**
     * The ID of the Deal
     * @maps deal_id
     * @var integer|null $dealId public property
     */
    public $dealId;

    /**
     * The ID of the Product
     * @maps product_id
     * @var integer|null $productId public property
     */
    public $productId;

    /**
     * The type of the duration. (For example hourly, daily, etc.)
     * @maps duration_unit
     * @var string|null $durationUnit public property
     */
    public $durationUnit;

    /**
     * The Product sum without the discount
     * @maps sum_no_discount
     * @var double|null $sumNoDiscount public property
     */
    public $sumNoDiscount;

    /**
     * The sum of all the Products attached to the Deal
     * @var double|null $sum public property
     */
    public $sum;

    /**
     * The currency associated with the Deal Product
     * @var string|null $currency public property
     */
    public $currency;

    /**
     * The date and time when the Product was added to the Deal
     * @maps add_time
     * @var string|null $addTime public property
     */
    public $addTime;

    /**
     * The date and time when the Deal Product was last edited
     * @maps last_edit
     * @var string|null $lastEdit public property
     */
    public $lastEdit;

    /**
     * Boolean indicates if the Product is activated or not
     * @maps active_flag
     * @var bool|null $activeFlag public property
     */
    public $activeFlag;

    /**
     * The Product tax
     * @var double|null $tax public property
     */
    public $tax;

    /**
     * The Product name
     * @var string|null $name public property
     */
    public $name;

    /**
     * Constructor to set initial or default values of member properties
     * @param double  $itemPrice          Initialization value for $this->itemPrice
     * @param integer $quantity           Initialization value for $this->quantity
     * @param double  $discountPercentage Initialization value for $this->discountPercentage
     * @param double  $duration           Initialization value for $this->duration
     * @param integer $productVariationId Initialization value for $this->productVariationId
     * @param string  $comments           Initialization value for $this->comments
     * @param int     $enabledFlag        Initialization value for $this->enabledFlag
     * @param integer $id                 Initialization value for $this->id
     * @param integer $companyId          Initialization value for $this->companyId
     * @param integer $dealId             Initialization value for $this->dealId
     * @param integer $productId          Initialization value for $this->productId
     * @param string  $durationUnit       Initialization value for $this->durationUnit
     * @param double  $sumNoDiscount      Initialization value for $this->sumNoDiscount
     * @param double  $sum                Initialization value for $this->sum
     * @param string  $currency           Initialization value for $this->currency
     * @param string  $addTime            Initialization value for $this->addTime
     * @param string  $lastEdit           Initialization value for $this->lastEdit
     * @param bool    $activeFlag         Initialization value for $this->activeFlag
     * @param double  $tax                Initialization value for $this->tax
     * @param string  $name               Initialization value for $this->name
     */
    public function __construct()
    {
        switch (func_num_args()) {
            case 20:
                $this->itemPrice          = func_get_arg(0);
                $this->quantity           = func_get_arg(1);
                $this->discountPercentage = func_get_arg(2);
                $this->duration           = func_get_arg(3);
                $this->productVariationId = func_get_arg(4);
                $this->comments           = func_get_arg(5);
                $this->enabledFlag        = func_get_arg(6);
                $this->id                 = func_get_arg(7);
                $this->companyId          = func_get_arg(8);
                $this->dealId             = func_get_arg(9);
                $this->productId          = func_get_arg(10);
                $this->durationUnit       = func_get_arg(11);
                $this->sumNoDiscount      = func_get_arg(12);
                $this->sum                = func_get_arg(13);
                $this->currency           = func_get_arg(14);
                $this->addTime            = func_get_arg(15);
                $this->lastEdit           = func_get_arg(16);
                $this->activeFlag         = func_get_arg(17);
                $this->tax                = func_get_arg(18);
                $this->name               = func_get_arg(19);
                break;

            default:
                $this->discountPercentage = 0;
                $this->duration = 1;
                break;
        }
    }


    /**
     * Encode this object to JSON
     */
    public function jsonSerialize()
    {
        $json = array();
        $json['item_price']           = $this->itemPrice;
        $json['quantity']             = $this->quantity;
        $json['discount_percentage']  = $this->discountPercentage;
        $json['duration']             = $this->duration;
        $json['product_variation_id'] = $this->productVariationId;
        $json['comments']             = $this->comments;
        $json['enabled_flag']         = $this->enabledFlag;
        $json['id']                   = $this->id;
        $json['company_id']           = $this->companyId;
        $json['deal_id']              = $this->dealId;
        $json['product_id']           = $this->productId;
        $json['duration_unit']        = $this->durationUnit;
        $json['sum_no_discount']      = $this->sumNoDiscount;
        $json['sum']                  = $this->sum;
        $json['currency']             = $this->currency;
        $json['add_time']             = $this->addTime;
        $json['last_edit']            = $this->lastEdit;
        $json['active_flag']          = $this->activeFlag;
        $json['tax']                  = $this->tax;
        $json['name']                 = $this->name;

        return $json;
    }
}
