<?php
/*
 * Pipedrive
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace Pipedrive;

/**
 * All configuration including auth info and base URI for the API access
 * are configured in this class.
 */
class Configuration
{
    /**
     * The environment being used'
     * @var string
     */
    public static $environment = Environments::PRODUCTION;

    public static $apiToken = '';
    /**
     * OAuth 2 Client ID
     * @var string
     */
    public static $oAuthClientId = 'TODO: Replace';

    /**
     * OAuth 2 Client Secret
     * @var string
     */
    public static $oAuthClientSecret = 'TODO: Replace';

    /**
     * OAuth 2 Redirection endpoint or Callback Uri
     * @var string
     */
    public static $oAuthRedirectUri = 'TODO: Replace';

    /**
     * OAuth 2 token
     * @var \Pipedrive\Models\OAuthToken
     */
    public static $oAuthToken = null;

    /**
     * OAuth token update callback
     * Called whenever token is updated
     * @var callable
     */
    public static $oAuthTokenUpdateCallback = null;

    /**
     * Get the base uri for a given server in the current environment
     * @param  string $server Server name
     * @return string         Base URI
     */
    public static function getBaseUri($server = Servers::DEFAULT_)
    {
        return APIHelper::appendUrlWithTemplateParameters(
            static::$environmentsMap[static::$environment][$server],
            array(
            )
        );
    }

    /**
     * A map of all baseurls used in different environments and servers
     * @var array
     */
    private static $environmentsMap = array(
        Environments::PRODUCTION => array(
            Servers::DEFAULT_ => 'https://api.pipedrive.com/v1',
            Servers::OAUTH => 'https://oauth.pipedrive.com',
        ),
    );
}
