<?php
function convertUnicodeString($str, $encoding=null) {
    if (is_null($encoding)) $encoding = ini_get('mbstring.internal_encoding');
    return preg_replace_callback('/u([0-9a-fA-F]{4})/u', function($match) use ($encoding) {
        return mb_convert_encoding(pack('H*', $match[1]), $encoding, 'UTF-16BE');
    }, $str);
}

function pipedrive($userId, $userPrflArr){
	include('config.php');
	include 'pipedrive/pipedrive-config.php';
	
	$accessKeySql = $con->query("SELECT access_key FROM intigration where `user_id`='".$userId."'");
	$integrationAccessKey = $accessKeySql->fetch_assoc();
	if(!empty($integrationAccessKey)){
		$accessKey=json_decode($integrationAccessKey['access_key']);
		(!empty($accessKey->pipedrive))?$pipedrive = $accessKey->pipedrive:$pipedrive = 0;
		(!empty($accessKey->pipedrive_api_key))?$pipedrive_api_key = $accessKey->pipedrive_api_key:$pipedrive_api_key = '';
		(!empty($accessKey->pipedriveOwner))?$pipedriveOwner = $accessKey->pipedriveOwner:$pipedriveOwner = '';
		(!empty($accessKey->pipedriveDefaultStage))?$pipedriveDefaultStage = $accessKey->pipedriveDefaultStage:$pipedriveDefaultStage = '';
		(!empty($accessKey->pipedriveContactPrivacy))?$pipedriveContactPrivacy = $accessKey->pipedriveContactPrivacy:$pipedriveContactPrivacy = '';
	}else{
		$pipedrive = 0;
		$pipedrive_api_key = '';
		$pipedriveOwner = '';
		$pipedriveDefaultStage = '';
		$pipedriveContactPrivacy = '';
	}
	if(!empty($pipedrive) && !empty($pipedrive_api_key)){
		$pipedriveContactId = '';
		$pipedriveOrgId = '';
		$email = $userPrflArr['emailAddress'];
		$phoneNumber = $userPrflArr['phoneNumbers'];
		$domain = '';
		
		if(!empty($email)){
			// Find person by email:
			$term = $email;
			$searchByEmail = 1; // Search only email field
		}else if(isset($_POST['profilefnamehub']) && isset($_POST['profilelnamehub']) && !empty($_POST['profilefnamehub']) && !empty($_POST['profilelnamehub'])){
			// Find person by fullname:
			$term = $userPrflArr['firstname'] . ' ' . $userPrflArr['lastname'];
			$searchByEmail = 0; // Search all field
		}
		
		$client = new Pipedrive\Client(null, null, null, $pipedrive_api_key); // First 3 parameters are for OAuth2
		
		$persons = $client->getPersons();
		if(!empty($term)){
			$collect = array('term' => $term, 'start' => 0, 'searchByEmail' => $searchByEmail);
			try {
				$personSearch = $persons->findPersonsByName($collect);
			} catch (\Pipedrive\APIException $e) {
				// Invalid API key
			}
			if(isset($personSearch->data) && !empty($personSearch->data)){
				if(1 <= count($personSearch->data) && count($personSearch->data) > 0){
					for($f = count($personSearch->data) - 1; 0 <= $f; $f--){
						if(isset($personSearch->data[$f]->id) && !empty($personSearch->data[$f]->id)){
							$pipedriveContactId = $personSearch->data[$f]->id;
							break;
						}
					}
				}
			}
			
			$profileInfoId = isset($userPrflArr['profileInfoId']) ? $userPrflArr['profileInfoId'] : '-1';
			$sqlProfileInfo = $con->query("SELECT * FROM `profileinfo` WHERE `id` = '" . $profileInfoId . "' ");
			
			$firstname = '';
			$lastname = '';
			$occupation = '';
			if ($sqlProfileInfo->num_rows > 0){
				$profileInfo = $sqlProfileInfo->fetch_assoc();
				$jsonData = $profileInfo['basicInfo'];
				$jsonData = preg_replace('/\s+/', ' ', $jsonData);
				$jsonData = utf8_encode($jsonData); 
				$basicInfo = json_decode($jsonData);

				if(isset($basicInfo->firstName) && isset($basicInfo->lastName) && isset($basicInfo->occupation)){
					$firstname = convertUnicodeString($basicInfo->firstName);
					$lastname = convertUnicodeString($basicInfo->lastName);
					$occupation = convertUnicodeString($basicInfo->occupation);
				}
			}
			
			$companyInfoId = isset($userPrflArr['companyInfoId']) ? $userPrflArr['companyInfoId'] : '-1';
			$sqlCompanyInfo = $con->query("SELECT * FROM `companyinfo` WHERE `id` = '" . $companyInfoId. "' ");
			if ($sqlCompanyInfo->num_rows > 0){
				$row_companyInfo = $sqlCompanyInfo->fetch_assoc();
				if ($row_companyInfo['company_li_id'] != 0) $domain = parse_url($row_companyInfo['company_page_url'], PHP_URL_HOST);
				$company_detail = json_decode(str_replace(']"','', str_replace('"[','',$row_companyInfo['company_detail'])));
				if(isset($company_detail->url)){$linkedin_company_page = $company_detail->url;} else { $linkedin_company_page = ''; }
				if(isset($company_detail->companyName)){$companyName = convertUnicodeString($company_detail->companyName); } else { $companyName =''; }
			}
 
			if(!empty($companyName)){
				$organizations = $client->getOrganizations();
				$orgData['term'] = $companyName;
				$orgData['start'] = 0;
				try{
					$organization = $organizations->findOrganizationsByName($orgData);
				} catch (\Pipedrive\APIException $e) {
					// Invalid API key
				}
				if(isset($organization->data) && !empty($organization->data)){
					if(1 <= count($organization->data) && count($organization->data) > 0){
						for($f = count($organization->data) - 1; 0 <= $f; $f--){
							if(isset($organization->data[$f]->id) && !empty($organization->data[$f]->id)){
								$pipedriveOrgId = $organization->data[$f]->id;
								break;
							}
						}
					}
				}
				if(empty($pipedriveOrgId)){
					$orgDataArr = array('name' => $companyName);
					if(!empty($pipedriveOwner))
						$orgDataArr['owner_id'] = array($pipedriveOwner);
					if(!empty($pipedriveContactPrivacy))
						$orgDataArr['visible_to'] = $pipedriveContactPrivacy;
					
					try {
						$newOrganization = $organizations->addAnOrganization($orgDataArr);
						if(isset($newOrganization->success) && $newOrganization->success == 1)
							$pipedriveOrgId = $newOrganization->data->id;
					} catch (\Pipedrive\APIException $e) {
						// Invalid API key
					}
				}
			}
			
			$data = array(
				'name' => $firstname . ' ' . $lastname,
				'first_name' => $firstname,
				'last_name' => $lastname,
				'linkedin_uid' => $userPrflArr['personId'],
				'linkedin' => $userPrflArr['linkedInURL'],
				'jobtitle' => $occupation,
				'contact_source' => 'LinkedIn',
				'contact_assigned_by' => $userPrflArr['siteTitle'],
				//$userPrflArr['sequenceSiteTitle'] => $userPrflArr['sequenceName']
				'sequence_name' => $userPrflArr['sequenceName']
			);
			
			if(!empty($domain))
				$data['website'] = $domain;
			if(!empty($pipedriveOrgId))
				$data['org_id'] = $pipedriveOrgId;
			
			if(!empty($phoneNumber)){
				$phnNumber = array($phoneNumber);
				if(is_array($phnNumber)){
					$data['phone'] = $phnNumber;
				}
			}else{
				$phnNumber = array($phoneNumber);
				if (is_array($phnNumber)){
					$data['phone'] = $phnNumber;
				}
			}
			
			if(!empty($email)){
				$emls = array($email);
				if(is_array($emls)){
					$data['email'] = $emls;
				}
			}else{
				$emls = array($email);
				if (is_array($emls)){
					$data['email'] = $emls;
				}
			}
			

			if(!empty($pipedriveOwner))
				$data['owner_id'] = array($pipedriveOwner);
			
			/********* To add custom fileds if not available in client's pipedrive account *************/
			$personFields = $client->getPersonFields();
			try{
				$prsnFlds = $personFields->getAllPersonFields();
			} catch (\Pipedrive\APIException $e) {
				// Invalid API key
			}

			if(isset($prsnFlds->success) && $prsnFlds->success == 1){
				$pipedriveFlds = $prsnFlds->data;
				if(isset($prsnFlds->data) && !empty($prsnFlds->data)){
					$pipedriveFldsArr = array();
					foreach($prsnFlds->data as $dt){
						$pipedriveFldsArr[] = $dt->name;
						if(isset($data[$dt->name])){
							$data[$dt->key] = $data[$dt->name];
							unset($data[$dt->name]);
						}		
					}
				}
			}
			/********* To add custom fileds if not available in client's pipedrive account *************/
			
			if(!empty($pipedriveContactId)){
				$data['id'] = $pipedriveContactId;
				try {
					if(!empty($data)){
						$persons->updateAPerson($data);
					}
				} catch (\Pipedrive\APIException $e) {
					// Invalid API key
				}
			}else{
				try {
					if(!empty($pipedriveContactPrivacy))
						$data['visible_to'] = $pipedriveContactPrivacy;
					$newPerson = $persons->addAPerson($data);
					if(isset($newPerson->success) && $newPerson->success == 1)
						$pipedriveContactId = $newPerson->data->id;
					if(isset($userPrflArr['isMsgSeq']) && $userPrflArr['isMsgSeq'] == '0'){
						$deals = $client->getDeals();
						$body = array('title' => $firstname . ' ' . $lastname . ' Deal', 'person_id' => $pipedriveContactId);
						if(!empty($pipedriveOwner)){
							$body['creator_user_id'] = $pipedriveOwner;
							$body['user_id'] = $pipedriveOwner;
						}
						if(!empty($pipedriveOrgId))
							$body['org_id'] = $pipedriveOrgId;
						if(!empty($pipedriveContactPrivacy))
							$body['visible_to'] = $pipedriveContactPrivacy;
						if(!empty($pipedriveDefaultStage))
							$body['stage_id'] = $pipedriveDefaultStage;
						$dl = $deals->addADeal($body);
						
						if(isset($dl->success) && $dl->success == 1){
							$dealId = $dl->data->id;
							$activities = $client->getActivities();
							$collection = array(
								'subject' => 'Invitation Accepted',
								'type' => 'task',
								'done' => 1,
								'dealId' => $dealId,
								'personId' => $pipedriveContactId,
								'note' => ''
							);
							
							if(!empty($pipedriveOwner))
								$collection['userId'] = $pipedriveOwner;
							if(!empty($pipedriveOrgId))
								$collection['orgId'] = $pipedriveOrgId;
							
							$addActivity = $activities->addAnActivity($collection);
						}
					}
				} catch (\Pipedrive\APIException $e) {
					// Invalid API key
				}
			}
		}
	}
}
?>