<?php
header("Access-Control-Allow-Origin:*");
header("Access-Control-Allow-Credentials:true");
header("Access-Control-Allow-Methods: OPTIONS, GET, POST");
header("Access-Control-Allow-Headers: Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <title>Spreadsheet</title>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="stylesheet" href="css/bootstrap.min.css">
        <link rel="stylesheet" href="css/font-awesome.min.css">
        <script src="js/jquery.min.js"></script>        
        <script src="js/bootstrap.min.js"></script>
    </head>
    <style>
        .error{
            color: red;
        }
    </style>
    <body>
        <?php
        include('config.php');
        session_start();
        $userid = $_SESSION['userid'];
        require __DIR__ . '/vendor/autoload.php';

        if (isset($_GET['code'])) {
            $code = $_GET['code'];
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://accounts.google.com/o/oauth2/token');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"grant_type\":\"authorization_code\",\"code\":\"$code\",\"client_id\":\"876131969173-pkm5mp0sqequj0r7itqhoq81kn1kam57.apps.googleusercontent.com\",\"client_secret\":\"B8NUDWZ6REg1wKrl43gvLp62\",\"redirect_uri\":\"https://nikit.intricare.net/cloud_theme/basic/api/googleapi/response.php\"}");
            $headers = array();
            $headers[] = 'Content-Type: application/json';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            $result = curl_exec($ch);
            if (curl_errno($ch)) {
                echo 'Error:' . curl_error($ch);
            }
            curl_close($ch);

            $tockenData = json_decode($result, true);

//    print_r($tockenData);
            $token_responce = json_encode($tockenData);




            $accessToken = $tockenData['access_token'];
            if (isset($tockenData['refresh_token'])) {

                $refresh_token = $tockenData['refresh_token'];
            } else {
                $refresh_token = "";
            }
            $addTask = "INSERT INTO spreadsheet_token (`access_token`,`refresh_token`,`token_responce`,`userId`) VALUES ('" . $accessToken . "','" . $refresh_token . "','" . $token_responce . "','$userid')";
            $taskQryExcute = mysqli_query($con, $addTask);

            $spreadsheetQry = mysqli_query($con, "SELECT * FROM `spreadsheet_token` where userId='$userid'");
            $spreadsheetData = mysqli_fetch_assoc($spreadsheetQry);
            header('Location: https://nikit.intricare.net/cloud_theme/basic/api/googleapi/response.php');
        } else {
            $spreadsheetQry = mysqli_query($con, "SELECT * FROM `spreadsheet_token` where userId='$userid'");
            $spreadsheetData = mysqli_fetch_assoc($spreadsheetQry);
            $accessToken = $spreadsheetData['access_token'];
        }

        function createShreadSheet($spreadsheetData) {
            include('config.php');
            $client = new Google_Client();
            $client->setApplicationName('Google Sheets Demo');
            $client->setScopes(Google_Service_Sheets::SPREADSHEETS);
            $client->setAuthConfig('client_secret.json');
            $client->setAccessType('offline');
            $client->setPrompt('select_account consent');


            if (!empty($spreadsheetData['token_responce'])) {
                $client->setAccessToken($spreadsheetData['token_responce']);
            }

            if ($client->isAccessTokenExpired()) {
                if ($client->getRefreshToken()) {
                    $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
                } else {
                    $newToken = $client->refreshToken($spreadsheetData['refresh_token']);
                    echo $newToken['access_token'];
                    $client->setAccessToken($newToken);
                    $updateAccess_token = mysqli_query($con, "UPDATE spreadsheet_token SET access_token = '" . $newToken['access_token'] . "' WHERE id = '" . $spreadsheetData['id'] . "'");
                }
            }


            $service = new Google_Service_Sheets($client);
            $spreadsheet = new Google_Service_Sheets_Spreadsheet([
                'properties' => [
                    'title' => $_POST["sheetName"]
                ]
            ]);
            $spreadsheet = $service->spreadsheets->create($spreadsheet, [
                'fields' => 'spreadsheetId'
            ]);
//            printf("Spreadsheet ID: %s\n", $spreadsheet->spreadsheetId);
            $addspreadsheet_info = "INSERT INTO spreadsheet_info (`spreadsheetId`,`sheetName`,`userId`) VALUES ('" . $spreadsheet->spreadsheetId . "','" . $_POST["sheetName"] . "','" . $_SESSION['userid'] . "')";
            $taskQryExcute = mysqli_query($con, $addspreadsheet_info);
        }

        if (isset($_POST['submit'])) {
            $client = createShreadSheet($spreadsheetData);
        }
        ?>
        <div class="container">
            <div class="row">
                <div class="col text-center">
                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#exampleModal">
                        Import Prospects
                    </button>
                </div>
            </div>
        </div>
        <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Import from Google Sheets</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="container">
                            <div class="row">
                                <div class="col-sm-12">   
                                    <button type="button" class="btn btn-outline-primary" onclick="showSheetNameForm()">CREATE SHEET</button>    
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12" id="SheetNameForm" style="display:  none;">
                                    <form method="post" action="response.php" id="sheetNameForm">
                                        <div class="form-group">
                                            <input type="text" class="form-control" name="sheetName" placeholder="Enter Sheet Name">
                                        </div>
                                        <div class="form-group">
                                            <input type="submit" class="btn btn-primary" value="Submit" name="submit"> 
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="row">
                                <?php
                                $spreadsheetQry = mysqli_query($con, "SELECT * FROM `spreadsheet_info` where userId='$userid'");
                                ?>
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Sheet Name</th>
                                            <th>Import Data</th>     
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php while ($spreadsheet = mysqli_fetch_assoc($spreadsheetQry)) { ?>    
                                            <tr>
                                                <td><a href="https://docs.google.com/spreadsheets/d/<?php echo $spreadsheet['spreadsheetId']; ?>" rel="nofollow" target="_blank"><?php echo $spreadsheet['sheetName']; ?></a></td>
                                                <td><a href="javascript:;" onclick="importsheet('<?php echo $spreadsheet['id']; ?>', '<?php echo $spreadsheet['spreadsheetId']; ?>', '<?php echo $spreadsheet['recordsInSheet']; ?>', '<?php echo $spreadsheet['userId']; ?>')">Import</a></td>        
                                            </tr>    
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>                        
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade" id="sheetFieldModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Map Google Sheet Fields</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">                        
                        <form id="sheetField">

                        </form>                        
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>                        
                    </div>
                </div>
            </div>
        </div>
        <script src="js/jquery.validate.min.js"></script>
        <script src="js/additional-methods.min.js"></script>
        <script>
                                                $("#sheetNameForm").validate({
                                                    rules: {
                                                        sheetName: {
                                                            required: true,
                                                        }
                                                    }
                                                });
        </script>
        <script>
            $("#sheetField").validate({
                rules: {
                    sheetValue: {
                        required: true,
                    }
                },
                errorPlacement: function (error, element) {
                    error.insertAfter(element.parent());
                },
                submitHandler: function (form) {
                }
            });
        </script>
        <script>
            function importsheet(id, spreadsheetId, recordsInSheet, userId) {
                $.ajax({
                    "url": "https://nikit.intricare.net/cloud_theme/basic/api/googleapi/readfromsheet.php",
                    "method": "POST",
                    "data": {"id": id, "spreadsheetId": spreadsheetId, "recordsInSheet": recordsInSheet, "userId": userId},
                    success: function (response) {
                        if (response == '0') {
                            alert("This Sheet appears to be empty. Try adding data and import again.");
                        } else {
                            var data = JSON.parse(response);
                            var html = "";
                            var StartAlphabet = "A";
                            for (var i = 0; i < data.length; i++) {
                                html += '<input type="radio" id="sheet' + StartAlphabet + '" name="sheetValue" value="' + StartAlphabet + '"><label id="sheet' + StartAlphabet + '" >' + data[i] + '</label><br>';
                                StartAlphabet = String.fromCharCode(StartAlphabet.charCodeAt(0) + 1);
                            }
                            html += '<button onclick="updatesheetdata(' + id + ')">Submit</button>';
                            document.getElementById("sheetField").innerHTML = html;

                            $("#sheetFieldModal").modal();
                        }
                    },
                    complete: function (xhr, textStatus) {
                    }
                });
            }
        </script>        
        <script>
            function updatesheetdata(id) {
                var sheetColumn = $('input[name="sheetValue"]:checked').val();
                if (typeof sheetColumn !== "undefined") {
                    $.ajax({
                        "url": "https://nikit.intricare.net/cloud_theme/basic/api/googleapi/updatesheetcolumn.php",
                        "method": "POST",
                        "data": {"id": id, "sheetColumn": sheetColumn},
                        success: function (response) {
                            location.reload();
                        },
                        complete: function (xhr, textStatus) {
                        }
                    });
                }
            }
        </script>
        <script>
            function showSheetNameForm() {
                $("#SheetNameForm").show();
            }
        </script>
    </body>
</html>
